/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.api.collections.AliasCmd;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionProperties;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintainRoutedAliasCmd
extends AliasCmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String INVOKED_BY_ROUTED_ALIAS = "invokedByRoutedAlias";
    static final String ROUTED_ALIAS_TARGET_COL = "routedAliasTargetCol";

    MaintainRoutedAliasCmd(CollectionCommandContext ccc) {
        super(ccc);
    }

    static void remoteInvoke(CollectionsHandler collHandler, String aliasName, String targetCol) throws Exception {
        CollectionParams.CollectionAction maintainroutedalias = CollectionParams.CollectionAction.MAINTAINROUTEDALIAS;
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("operation", maintainroutedalias.toLower());
        msg.put("name", aliasName);
        msg.put(ROUTED_ALIAS_TARGET_COL, targetCol);
        SolrResponse rsp = collHandler.submitCollectionApiCommand(new ZkNodeProps(msg), maintainroutedalias);
        if (rsp.getException() != null) {
            throw rsp.getException();
        }
    }

    void addCollectionToAlias(String aliasName, ZkStateReader.AliasesManager aliasesManager, String createCollName) {
        aliasesManager.applyModificationAndExportToZk(curAliases -> {
            List curTargetCollections = (List)curAliases.getCollectionAliasListMap().get(aliasName);
            if (curTargetCollections.contains(createCollName)) {
                return curAliases;
            }
            ArrayList<String> newTargetCollections = new ArrayList<String>(curTargetCollections.size() + 1);
            newTargetCollections.add(createCollName);
            newTargetCollections.addAll(curTargetCollections);
            return curAliases.cloneWithCollectionAlias(aliasName, StrUtils.join(newTargetCollections, (char)','));
        });
    }

    private void removeCollectionFromAlias(String aliasName, ZkStateReader.AliasesManager aliasesManager, String createCollName) {
        aliasesManager.applyModificationAndExportToZk(curAliases -> {
            List curTargetCollections = (List)curAliases.getCollectionAliasListMap().get(aliasName);
            if (curTargetCollections.contains(createCollName)) {
                ArrayList newTargetCollections = new ArrayList(curTargetCollections.size());
                newTargetCollections.addAll(curTargetCollections);
                newTargetCollections.remove(createCollName);
                return curAliases.cloneWithCollectionAlias(aliasName, StrUtils.join(newTargetCollections, (char)','));
            }
            return curAliases;
        });
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String aliasName = message.getStr("name");
        String routeValue = message.getStr(ROUTED_ALIAS_TARGET_COL);
        ZkStateReader.AliasesManager aliasesManager = this.ccc.getZkStateReader().aliasesManager;
        Aliases aliases = aliasesManager.getAliases();
        Map aliasMetadata = aliases.getCollectionAliasProperties(aliasName);
        if (aliasMetadata.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Alias " + aliasName + " does not exist or is not a routed alias.");
        }
        RoutedAlias ra = RoutedAlias.fromProps(aliasName, aliasMetadata);
        if (ra == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "MaintainRoutedAlias called on non-routed alias");
        }
        ra.updateParsedCollectionAliases(this.ccc.getZkStateReader(), true);
        List<RoutedAlias.Action> actions = ra.calculateActions(routeValue);
        block4: for (RoutedAlias.Action action : actions) {
            boolean exists = this.ccc.getZkStateReader().getClusterState().getCollectionOrNull(action.targetCollection) != null;
            switch (action.actionType) {
                case ENSURE_REMOVED: {
                    if (!exists) continue block4;
                    this.ccc.getExecutorService().execute(() -> {
                        try {
                            this.deleteTargetCollection(clusterState, results, aliasName, aliasesManager, action);
                        }
                        catch (Exception e) {
                            log.warn("Deletion of {} by {} {} failed (this might be ok if two clients were", new Object[]{action.targetCollection, ra.getAliasName(), " writing to a routed alias at the same time and both caused a deletion)"});
                            log.debug("Exception for last message:", (Throwable)e);
                        }
                    });
                    break;
                }
                case ENSURE_EXISTS: {
                    if (!exists) {
                        this.addTargetCollection(clusterState, results, aliasName, aliasesManager, aliasMetadata, action);
                        break;
                    }
                    if (ra.getCollectionList(aliases).contains(action.targetCollection)) continue block4;
                    this.addCollectionToAlias(aliasName, aliasesManager, action.targetCollection);
                    Map collectionProperties = this.ccc.getZkStateReader().getCollectionProperties(action.targetCollection, 1000L);
                    if (collectionProperties.containsKey("routedAliasName")) continue block4;
                    CollectionProperties props = new CollectionProperties(this.ccc.getZkStateReader().getZkClient());
                    props.setCollectionProperty(action.targetCollection, "routedAliasName", aliasName);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown action type!");
                }
            }
        }
    }

    public void addTargetCollection(ClusterState clusterState, NamedList<Object> results, String aliasName, ZkStateReader.AliasesManager aliasesManager, Map<String, String> aliasMetadata, RoutedAlias.Action action) throws Exception {
        NamedList<Object> createResults = MaintainRoutedAliasCmd.createCollectionAndWait(clusterState, aliasName, aliasMetadata, action.targetCollection, this.ccc);
        if (createResults != null) {
            results.add("create", createResults);
        }
        this.addCollectionToAlias(aliasName, aliasesManager, action.targetCollection);
    }

    public void deleteTargetCollection(ClusterState clusterState, NamedList<Object> results, String aliasName, ZkStateReader.AliasesManager aliasesManager, RoutedAlias.Action action) throws Exception {
        HashMap<String, Object> delProps = new HashMap<String, Object>();
        delProps.put(INVOKED_BY_ROUTED_ALIAS, () -> this.removeCollectionFromAlias(aliasName, aliasesManager, action.targetCollection));
        delProps.put("name", action.targetCollection);
        ZkNodeProps messageDelete = new ZkNodeProps(delProps);
        new DeleteCollectionCmd(this.ccc).call(clusterState, messageDelete, results);
    }
}

