/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.ObjectHashSet;
import java.io.Closeable;
import java.io.StringWriter;
import java.util.Arrays;
import org.carrot2.language.LanguageComponents;
import org.carrot2.language.TokenTypeUtils;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.SparseArray;
import org.carrot2.util.MutableCharArray;
import org.carrot2.util.TabularOutput;

public final class PreprocessingContext
implements Closeable {
    private static final String UNINITIALIZED = "[uninitialized]\n";
    public final LanguageComponents languageComponents;
    public int documentCount;
    private ObjectHashSet<MutableCharArray> tokenCache = new ObjectHashSet();
    public final AllTokens allTokens = new AllTokens();
    public final AllFields allFields = new AllFields();
    public final AllWords allWords = new AllWords();
    public final AllStems allStems = new AllStems();
    public AllPhrases allPhrases = new AllPhrases();
    public final AllLabels allLabels = new AllLabels();
    private static final int[][] bitsCache = new int[256][];

    public PreprocessingContext(LanguageComponents languageComponents) {
        this.languageComponents = languageComponents;
    }

    public boolean hasWords() {
        return this.allWords.image.length > 0;
    }

    public boolean hasLabels() {
        return this.allLabels.featureIndex != null && this.allLabels.featureIndex.length > 0;
    }

    public String format(LabelFormatter formatter, int featureIndex) {
        char[][] wordsImage = this.allWords.image;
        if (featureIndex < wordsImage.length) {
            return formatter.format(new char[][]{wordsImage[featureIndex]}, new boolean[]{false});
        }
        int[] wordIndices = this.allPhrases.wordIndices[featureIndex - wordsImage.length];
        short[] termTypes = this.allWords.type;
        char[][] wordImages = new char[wordIndices.length][];
        boolean[] stopwordFlags = new boolean[wordIndices.length];
        for (int i = 0; i < wordIndices.length; ++i) {
            int wordIndex = wordIndices[i];
            wordImages[i] = wordsImage[wordIndex];
            stopwordFlags[i] = TokenTypeUtils.isCommon(termTypes[wordIndex]);
        }
        return formatter.format(wordImages, stopwordFlags);
    }

    public String toString() {
        return "PreprocessingContext 0x" + Integer.toHexString(this.hashCode()) + "\n== Fields:\n" + this.allFields.toString() + "== Tokens:\n" + this.allTokens.toString() + "== Words:\n" + this.allWords.toString() + "== Stems:\n" + this.allStems.toString() + "== Phrases:\n" + this.allPhrases.toString() + "== Labels:\n" + this.allLabels.toString();
    }

    public static int[] toFieldIndexes(byte b) {
        return bitsCache[b & 0xFF];
    }

    @Override
    public void close() {
        this.tokenCache = null;
    }

    public char[] intern(MutableCharArray chs) {
        int index = this.tokenCache.indexOf((Object)chs);
        if (this.tokenCache.indexExists(index)) {
            return ((MutableCharArray)this.tokenCache.indexGet(index)).getBuffer();
        }
        char[] tokenImage = new char[chs.length()];
        System.arraycopy(chs.getBuffer(), chs.getStart(), tokenImage, 0, chs.length());
        this.tokenCache.add((Object)new MutableCharArray(tokenImage));
        return tokenImage;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PreprocessingContext.bitsCache[i] = new int[Integer.bitCount(i & 0xFF)];
            int v = 0;
            int bit = 0;
            int j = i & 0xFF;
            while (j != 0) {
                if ((j & 1) != 0) {
                    PreprocessingContext.bitsCache[i][v++] = bit;
                }
                j >>>= 1;
                ++bit;
            }
        }
    }

    public class AllLabels {
        public int[] featureIndex;
        public BitSet[] documentIndices;
        public int firstPhraseIndex;

        public String toString() {
            if (this.featureIndex == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter sw = new StringWriter();
            TabularOutput t = TabularOutput.to(sw).noAutoFlush().addColumn("#").addColumn("featureIdx").addColumn("=>feature", spec -> spec.alignLeft()).addColumn("documentIdx", spec -> spec.alignLeft()).build();
            for (int i = 0; i < this.featureIndex.length; ++i) {
                t.append(i, this.featureIndex[i], this.getLabel(i), this.documentIndices != null ? this.documentIndices[i].toString().replace(" ", "") : "");
                t.nextRow();
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }

        public CharSequence getLabel(int index) {
            int wordsSize = PreprocessingContext.this.allWords.image.length;
            if (this.featureIndex[index] < wordsSize) {
                return new String(PreprocessingContext.this.allWords.image[this.featureIndex[index]]);
            }
            return PreprocessingContext.this.allPhrases.getPhrase(this.featureIndex[index] - wordsSize);
        }

        public int size() {
            return this.featureIndex.length;
        }
    }

    public class AllPhrases {
        public int[][] wordIndices;
        public int[] tf;
        public int[][] tfByDocument;

        public String toString() {
            if (this.wordIndices == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter sw = new StringWriter();
            TabularOutput t = TabularOutput.to(sw).noAutoFlush().addColumn("#").addColumn("wordIndices").addColumn("=>words", spec -> spec.alignLeft()).addColumn("tf").addColumn("tfByDocument", spec -> spec.alignLeft()).build();
            for (int i = 0; i < this.wordIndices.length; ++i) {
                t.append(i, Arrays.toString(this.wordIndices[i]).replace(" ", ""), this.getPhrase(i), this.tf[i], SparseArray.sparseToString(this.tfByDocument[i]));
                t.nextRow();
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }

        public CharSequence getPhrase(int index) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.wordIndices[index].length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(new String(PreprocessingContext.this.allWords.image[this.wordIndices[index][i]]));
            }
            return sb;
        }

        public int size() {
            return this.wordIndices.length;
        }
    }

    public class AllStems {
        public char[][] image;
        public int[] mostFrequentOriginalWordIndex;
        public int[] tf;
        public int[][] tfByDocument;
        public byte[] fieldIndices;

        public String toString() {
            if (this.image == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter sw = new StringWriter();
            TabularOutput t = TabularOutput.to(sw).noAutoFlush().addColumn("#").addColumn("stem").addColumn("mostFrqWord").addColumn("=>mostFrqWord", spec -> spec.alignLeft()).addColumn("tf").addColumn("tfByDocument", spec -> spec.alignLeft()).addColumn("fieldIndices").build();
            for (int i = 0; i < this.image.length; ++i) {
                t.append(i, this.image[i] == null ? "<null>" : new String(this.image[i]), this.mostFrequentOriginalWordIndex[i], new String(PreprocessingContext.this.allWords.image[this.mostFrequentOriginalWordIndex[i]]), this.tf[i], SparseArray.sparseToString(this.tfByDocument[i]), Arrays.toString(PreprocessingContext.toFieldIndexes(this.fieldIndices[i])).replace(" ", ""));
                t.nextRow();
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }
    }

    public class AllWords {
        public char[][] image;
        public short[] type;
        public int[] tf;
        public int[][] tfByDocument;
        public int[] stemIndex;
        public byte[] fieldIndices;

        public String toString() {
            if (this.image == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter sw = new StringWriter();
            TabularOutput.Builder builder = TabularOutput.to(sw).noAutoFlush().addColumn("#").addColumn("image", spec -> spec.alignLeft()).addColumn("type").addColumn("tf").addColumn("tfByDocument", spec -> spec.alignLeft()).addColumn("fieldIndices");
            if (this.stemIndex != null) {
                builder.addColumn("stemIndex");
                builder.addColumn("=>stem", spec -> spec.alignLeft());
            }
            TabularOutput t = builder.build();
            for (int i = 0; i < this.image.length; ++i) {
                t.append(i, this.image[i] == null ? "<null>" : new String(this.image[i]), this.type[i], this.tf[i], SparseArray.sparseToString(this.tfByDocument[i]));
                t.append(Arrays.toString(PreprocessingContext.toFieldIndexes(this.fieldIndices[i])).replace(" ", ""));
                if (this.stemIndex != null) {
                    t.append(this.stemIndex[i]);
                    t.append(new String(PreprocessingContext.this.allStems.image[this.stemIndex[i]]));
                }
                t.nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }
    }

    public static class AllFields {
        public String[] name;

        public String toString() {
            if (this.name == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter sw = new StringWriter();
            TabularOutput t = TabularOutput.to(sw).noAutoFlush().addColumn("#").addColumn("name", spec -> spec.format("%-10s").alignLeft()).build();
            int i = 0;
            for (String n : this.name) {
                t.append(i++, n).nextRow();
            }
            t.flush();
            sw.append("\n");
            return sw.toString();
        }

        public int fieldIndex(String fieldName) {
            return Arrays.asList(this.name).indexOf(fieldName);
        }
    }

    public class AllTokens {
        public char[][] image;
        public short[] type;
        public byte[] fieldIndex;
        public int[] documentIndex;
        public int[] wordIndex;
        public int[] suffixOrder;
        public int[] lcp;

        public String toString() {
            if (this.image == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter sw = new StringWriter();
            TabularOutput t = TabularOutput.to(sw).noAutoFlush().addColumn("#").addColumn("token", spec -> spec.alignLeft()).addColumn("type").addColumn("fieldIndex").addColumn("=>field", spec -> spec.alignLeft()).addColumn("docIdx").addColumn("wordIdx").addColumn("=>word", spec -> spec.alignLeft()).build();
            for (int i = 0; i < this.image.length; ++i) {
                t.append(i, this.image[i] == null ? "<null>" : new String(this.image[i]), this.type[i], this.fieldIndex[i], this.fieldIndex[i] >= 0 ? PreprocessingContext.this.allFields.name[this.fieldIndex[i]] : null, this.documentIndex[i], this.wordIndex[i], this.wordIndex[i] >= 0 ? new String(PreprocessingContext.this.allWords.image[this.wordIndex[i]]) : null);
                t.nextRow();
                t.nextRow();
            }
            t.flush();
            if (this.suffixOrder != null) {
                t = TabularOutput.to(sw).noAutoFlush().addColumn("#").addColumn("sa").addColumn("lcp").addColumn("=>words", spec -> spec.alignLeft()).build();
                sw.append("\n");
                StringBuilder suffixImage = new StringBuilder();
                for (int i = 0; i < this.suffixOrder.length; ++i) {
                    t.append(i, this.suffixOrder[i], this.lcp[i]);
                    int windowLength = 5;
                    int j = this.suffixOrder[i];
                    int max = Math.min(this.suffixOrder[i] + windowLength, this.wordIndex.length);
                    while (j < max) {
                        suffixImage.append(this.wordIndex[j] >= 0 ? new String(PreprocessingContext.this.allWords.image[this.wordIndex[j]]) : "|").append(" ");
                        if (++j != max || j == this.wordIndex.length) continue;
                        suffixImage.append(" [...]");
                    }
                    t.append(suffixImage.toString());
                    t.nextRow();
                    suffixImage.setLength(0);
                    t.nextRow();
                }
                sw.append("\n");
                t.flush();
            }
            sw.append("\n");
            return sw.toString();
        }
    }
}

