/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jhotdraw.beans.Disposable;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.PictImageInputFormat;
import org.jhotdraw.draw.QuadTreeDrawing;
import org.jhotdraw.draw.TextInputFormat;
import org.jhotdraw.gui.ToolBarLayout;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.gui.ActionsToolBar;
import org.jhotdraw.samples.svg.gui.AlignToolBar;
import org.jhotdraw.samples.svg.gui.ArrangeToolBar;
import org.jhotdraw.samples.svg.gui.CanvasToolBar;
import org.jhotdraw.samples.svg.gui.FigureToolBar;
import org.jhotdraw.samples.svg.gui.FillToolBar;
import org.jhotdraw.samples.svg.gui.FontToolBar;
import org.jhotdraw.samples.svg.gui.LinkToolBar;
import org.jhotdraw.samples.svg.gui.StrokeToolBar;
import org.jhotdraw.samples.svg.gui.ToolsToolBar;
import org.jhotdraw.samples.svg.gui.ViewToolBar;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class SVGDrawingPanel
extends JPanel
implements Disposable {
    private UndoRedoManager undoManager;
    private DrawingEditor editor;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    private Preferences prefs;
    private ContainerListener containerHandler;
    private ActionsToolBar actionToolBar;
    private AlignToolBar alignToolBar;
    private ArrangeToolBar arrangeToolBar;
    private CanvasToolBar canvasToolBar;
    private ToolsToolBar creationToolBar;
    private FigureToolBar figureToolBar;
    private FillToolBar fillToolBar;
    private FontToolBar fontToolBar;
    private LinkToolBar linkToolBar;
    private JScrollPane scrollPane;
    private StrokeToolBar strokeToolBar;
    private ButtonGroup toolButtonGroup;
    private JPanel toolsPane;
    private JPanel toolsPanel;
    private JScrollPane toolsScrollPane;
    private DefaultDrawingView view;
    private ViewToolBar viewToolBar;

    public UndoRedoManager getUndoRedoManager() {
        return this.undoManager;
    }

    public void setUndoRedoManager(UndoRedoManager undoRedoManager) {
        if (this.undoManager != null && this.getView().getDrawing() != null) {
            this.getView().getDrawing().removeUndoableEditListener(this.undoManager);
        }
        this.undoManager = undoRedoManager;
        if (this.undoManager != null && this.getView().getDrawing() != null) {
            this.getView().getDrawing().addUndoableEditListener(this.undoManager);
        }
    }

    public SVGDrawingPanel() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        try {
            this.prefs = PreferencesUtil.userNodeForPackage(this.getClass());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.initComponents();
        this.toolsPane.setLayout(new ToolBarLayout());
        this.toolsPane.setBackground(new Color(0xF0F0F0));
        this.toolsPane.setOpaque(true);
        this.viewToolBar.setView(this.view);
        this.undoManager = new UndoRedoManager();
        Drawing drawing = this.createDrawing();
        this.view.setDrawing(drawing);
        drawing.addUndoableEditListener(this.undoManager);
        try {
            this.view.setTransferHandler((TransferHandler)Class.forName("org.jhotdraw.draw.DnDDrawingViewTransferHandler").newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<JToolBar> arrayList = new ArrayList<JToolBar>();
        for (Component component : this.toolsPane.getComponents()) {
            if (!(component instanceof JToolBar)) continue;
            arrayList.add((JToolBar)component);
        }
        Collections.sort(arrayList, new Comparator<JToolBar>(){

            @Override
            public int compare(JToolBar jToolBar, JToolBar jToolBar2) {
                int n = SVGDrawingPanel.this.prefs.getInt("toolBarIndex." + jToolBar.getName(), 0);
                int n2 = SVGDrawingPanel.this.prefs.getInt("toolBarIndex." + jToolBar2.getName(), 0);
                return n - n2;
            }
        });
        this.toolsPane.removeAll();
        for (JToolBar jToolBar : arrayList) {
            this.toolsPane.add(jToolBar);
        }
        this.containerHandler = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                int n = 0;
                for (Component component : SVGDrawingPanel.this.toolsPane.getComponents()) {
                    if (!(component instanceof JToolBar)) continue;
                    JToolBar jToolBar = (JToolBar)component;
                    SVGDrawingPanel.this.prefs.putInt("toolBarIndex." + jToolBar.getName(), n);
                    ++n;
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
            }
        };
        this.toolsPane.addContainerListener(this.containerHandler);
        this.setEditor(new DefaultDrawingEditor());
    }

    @Override
    public void dispose() {
        this.toolsPane.removeContainerListener(this.containerHandler);
        this.containerHandler = null;
        this.setEditor(null);
        for (PropertyChangeListener propertyChangeListener : (PropertyChangeListener[])this.view.getListeners(PropertyChangeListener.class)) {
            this.view.removePropertyChangeListener(propertyChangeListener);
        }
        this.view.setDrawing(null);
        this.actionToolBar.dispose();
        this.alignToolBar.dispose();
        this.arrangeToolBar.dispose();
        this.canvasToolBar.dispose();
        this.creationToolBar.dispose();
        this.figureToolBar.dispose();
        this.fillToolBar.dispose();
        this.fontToolBar.dispose();
        this.linkToolBar.dispose();
        this.strokeToolBar.dispose();
        this.viewToolBar.dispose();
        this.removeAll();
    }

    public Drawing createDrawing() {
        QuadTreeDrawing quadTreeDrawing = new QuadTreeDrawing();
        LinkedList<InputFormat> linkedList = new LinkedList<InputFormat>();
        linkedList.add(new SVGZInputFormat());
        linkedList.add(new ImageInputFormat(new SVGImageFigure()));
        linkedList.add(new ImageInputFormat(new SVGImageFigure(), "JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        linkedList.add(new ImageInputFormat(new SVGImageFigure(), "GIF", "Graphics Interchange Format (GIF)", "gif", 2));
        linkedList.add(new ImageInputFormat(new SVGImageFigure(), "PNG", "Portable Network Graphics (PNG)", "png", 2));
        linkedList.add(new PictImageInputFormat(new SVGImageFigure()));
        linkedList.add(new TextInputFormat(new SVGTextFigure()));
        quadTreeDrawing.setInputFormats(linkedList);
        LinkedList<OutputFormat> linkedList2 = new LinkedList<OutputFormat>();
        linkedList2.add(new SVGOutputFormat());
        linkedList2.add(new SVGZOutputFormat());
        linkedList2.add(new ImageOutputFormat());
        linkedList2.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        linkedList2.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        linkedList2.add(new ImageMapOutputFormat());
        quadTreeDrawing.setOutputFormats(linkedList2);
        return quadTreeDrawing;
    }

    public void setDrawing(Drawing drawing) {
        this.undoManager.discardAllEdits();
        if (this.view.getDrawing() != null) {
            this.view.getDrawing().removeUndoableEditListener(this.undoManager);
        }
        this.view.setDrawing(drawing);
        drawing.addUndoableEditListener(this.undoManager);
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor drawingEditor) {
        DrawingView drawingView;
        DrawingEditor drawingEditor2 = this.editor;
        if (drawingEditor2 != null) {
            drawingEditor2.remove(this.view);
        }
        this.editor = drawingEditor;
        if (drawingEditor != null) {
            drawingEditor.add(this.view);
        }
        this.creationToolBar.setEditor(this.editor);
        this.fillToolBar.setEditor(this.editor);
        this.strokeToolBar.setEditor(this.editor);
        this.actionToolBar.setUndoManager(this.undoManager);
        this.actionToolBar.setEditor(this.editor);
        this.alignToolBar.setEditor(this.editor);
        this.arrangeToolBar.setEditor(this.editor);
        this.fontToolBar.setEditor(this.editor);
        this.figureToolBar.setEditor(this.editor);
        this.linkToolBar.setEditor(this.editor);
        DrawingView drawingView2 = drawingView = this.editor == null ? null : this.editor.getActiveView();
        if (this.editor != null) {
            this.editor.setActiveView(this.view);
        }
        this.canvasToolBar.setEditor(this.editor);
        this.viewToolBar.setEditor(this.editor);
        if (this.editor != null) {
            this.editor.setActiveView(drawingView);
        }
    }

    public void read(File file) throws IOException {
        Drawing drawing = this.createDrawing();
        if (drawing.getInputFormats().size() == 0) {
            throw new InternalError("Drawing object has no input formats.");
        }
        IOException iOException = null;
        for (InputFormat inputFormat : drawing.getInputFormats()) {
            try {
                inputFormat.read(file, drawing);
                final Drawing drawing2 = drawing;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SVGDrawingPanel.this.setDrawing(drawing2);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        InternalError internalError = new InternalError("Error setting drawing.");
                        internalError.initCause(invocationTargetException);
                        throw internalError;
                    }
                }
                return;
            }
            catch (IOException iOException2) {
                if (iOException != null) continue;
                iOException = iOException2;
            }
        }
        throw iOException;
    }

    public void read(File file, InputFormat inputFormat) throws IOException {
        if (inputFormat == null) {
            this.read(file);
            return;
        }
        Drawing drawing = this.createDrawing();
        if (drawing.getInputFormats().size() == 0) {
            throw new InternalError("Drawing object has no input formats.");
        }
        inputFormat.read(file, drawing);
        final Drawing drawing2 = drawing;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SVGDrawingPanel.this.setDrawing(drawing2);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                InternalError internalError = new InternalError("Error setting drawing.");
                internalError.initCause(invocationTargetException);
                throw internalError;
            }
        }
    }

    public void write(File file) throws IOException {
        final Drawing[] drawingArray = new Drawing[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                drawingArray[0] = (Drawing)SVGDrawingPanel.this.getDrawing().clone();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                InternalError internalError = new InternalError("Error getting drawing.");
                internalError.initCause(invocationTargetException);
                throw internalError;
            }
        }
        Drawing drawing = drawingArray[0];
        if (drawing.getOutputFormats().size() == 0) {
            throw new InternalError("Drawing object has no output formats.");
        }
        for (OutputFormat outputFormat : drawing.getOutputFormats()) {
            if (!outputFormat.getFileFilter().accept(file)) continue;
            outputFormat.write(file, drawing);
            return;
        }
        throw new IOException("No output format for " + file.getName());
    }

    public void write(File file, OutputFormat outputFormat) throws IOException {
        if (outputFormat == null) {
            this.write(file);
            return;
        }
        final Drawing[] drawingArray = new Drawing[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                drawingArray[0] = (Drawing)SVGDrawingPanel.this.getDrawing().clone();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                InternalError internalError = new InternalError("Error getting drawing.");
                internalError.initCause(invocationTargetException);
                throw internalError;
            }
        }
        Drawing drawing = drawingArray[0];
        outputFormat.write(file, drawing);
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.toolsPanel = new JPanel();
        this.toolsScrollPane = new JScrollPane();
        this.toolsPane = new JPanel();
        this.creationToolBar = new ToolsToolBar();
        this.actionToolBar = new ActionsToolBar();
        this.fillToolBar = new FillToolBar();
        this.strokeToolBar = new StrokeToolBar();
        this.fontToolBar = new FontToolBar();
        this.arrangeToolBar = new ArrangeToolBar();
        this.alignToolBar = new AlignToolBar();
        this.figureToolBar = new FigureToolBar();
        this.linkToolBar = new LinkToolBar();
        this.canvasToolBar = new CanvasToolBar();
        this.viewToolBar = new ViewToolBar();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.toolsPanel.setBackground(new Color(255, 255, 255));
        this.toolsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toolsPanel.setOpaque(true);
        this.toolsPanel.setLayout(new GridBagLayout());
        this.toolsScrollPane.setBorder(PaletteLookAndFeel.getInstance().getBorder("Ribbon.border"));
        this.toolsScrollPane.setHorizontalScrollBarPolicy(32);
        this.toolsScrollPane.setVerticalScrollBarPolicy(21);
        this.toolsScrollPane.setMinimumSize(new Dimension(0, 0));
        this.toolsPane.setForeground(new Color(153, 153, 153));
        this.toolsPane.add(this.creationToolBar);
        this.toolsPane.add(this.actionToolBar);
        this.toolsPane.add(this.fillToolBar);
        this.strokeToolBar.setMargin(new Insets(0, 10, 0, 0));
        this.toolsPane.add(this.strokeToolBar);
        this.toolsPane.add(this.fontToolBar);
        this.toolsPane.add(this.arrangeToolBar);
        this.toolsPane.add(this.alignToolBar);
        this.toolsPane.add(this.figureToolBar);
        this.toolsPane.add(this.linkToolBar);
        this.toolsPane.add(this.canvasToolBar);
        this.toolsPane.add(this.viewToolBar);
        this.toolsScrollPane.setViewportView(this.toolsPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.toolsPanel.add((Component)this.toolsScrollPane, gridBagConstraints);
        this.add((Component)this.toolsPanel, "South");
    }

    public JComponent getComponent() {
        return this;
    }

    private class ItemChangeHandler
    implements ItemListener {
        private JToolBar toolbar;
        private String prefkey;

        public ItemChangeHandler(JToolBar jToolBar, String string) {
            this.toolbar = jToolBar;
            this.prefkey = string;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.toolbar.setVisible(bl);
            SVGDrawingPanel.this.prefs.putBoolean(this.prefkey, bl);
            SVGDrawingPanel.this.validate();
        }
    }
}

