/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.autofilter.AutoFilter;
import org.openstreetmap.josm.gui.autofilter.AutoFilterButton;
import org.openstreetmap.josm.gui.autofilter.AutoFilterRule;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.widgets.OSDLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class AutoFilterManager
implements NavigatableComponent.ZoomChangeListener,
MapFrame.MapModeChangeListener,
DataSetListener,
PreferenceChangedListener,
LayerManager.LayerChangeListener {
    public static final BooleanProperty PROP_AUTO_FILTER_ENABLED = new BooleanProperty("auto.filter.enabled", true);
    public static final StringProperty PROP_AUTO_FILTER_RULE = new StringProperty("auto.filter.rule", "level");
    private static volatile AutoFilterManager instance;
    private final Map<String, AutoFilterButton> buttons = new TreeMap<String, AutoFilterButton>();
    private final List<AutoFilterRule> rules = new ArrayList<AutoFilterRule>();
    private final OSDLabel lblOSD = new OSDLabel("");
    private final FilterModel model = new FilterModel();
    private AutoFilterRule enabledRule;
    private AutoFilter currentAutoFilter;

    public static AutoFilterManager getInstance() {
        if (instance == null) {
            instance = new AutoFilterManager();
        }
        return instance;
    }

    private AutoFilterManager() {
        MapFrame.addMapModeChangeListener(this);
        Config.getPref().addPreferenceChangeListener(this);
        NavigatableComponent.addZoomChangeListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        this.registerAutoFilterRules(AutoFilterRule.defaultRules());
    }

    private synchronized void updateButtons() {
        MapFrame map = MainApplication.getMap();
        if (this.enabledRule != null && map != null && this.enabledRule.getMinZoomLevel() <= Selector.GeneralSelector.scale2level(map.mapView.getDist100Pixel())) {
            NavigableSet<String> values = AutoFilterManager.getNumericValues(this.enabledRule.getKey(), this.enabledRule.getValueComparator());
            if (this.currentAutoFilter != null) {
                values.add(this.currentAutoFilter.getFilter().text.split("=")[1]);
            }
            if (!values.equals(this.buttons.keySet())) {
                this.removeAllButtons();
                this.addNewButtons(values);
            }
        }
    }

    private synchronized void addNewButtons(NavigableSet<String> values) {
        int i = 0;
        int maxWidth = 16;
        MapView mapView = MainApplication.getMap().mapView;
        for (String value : values.descendingSet()) {
            Filter filter = new Filter();
            filter.enable = true;
            filter.inverted = true;
            filter.text = this.enabledRule.getKey() + "=" + value;
            String label = this.enabledRule.getValueFormatter().apply(value);
            AutoFilter autoFilter = new AutoFilter(label, filter.text, filter);
            AutoFilterButton button = new AutoFilterButton(autoFilter);
            if (autoFilter.equals(this.currentAutoFilter)) {
                button.getModel().setPressed(true);
            }
            this.buttons.put(value, button);
            maxWidth = Math.max(maxWidth, button.getPreferredSize().width);
            mapView.add(button).setLocation(3, 60 + 22 * i++);
        }
        for (AutoFilterButton b : this.buttons.values()) {
            b.setSize(maxWidth, 20);
        }
        mapView.validate();
    }

    private void removeAllButtons() {
        Iterator<String> it = this.buttons.keySet().iterator();
        while (it.hasNext()) {
            MainApplication.getMap().mapView.remove(this.buttons.get(it.next()));
            it.remove();
        }
    }

    private static NavigableSet<String> getNumericValues(String key, Comparator<String> comparator) {
        TreeSet<String> values = new TreeSet<String>(comparator);
        for (String s : AutoFilterManager.getTagValues(key)) {
            try {
                Integer.parseInt(s);
                values.add(s);
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
        return values;
    }

    private static Set<String> getTagValues(String key) {
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        TreeSet<String> values = new TreeSet<String>();
        if (ds != null) {
            BBox bbox = MainApplication.getMap().mapView.getState().getViewArea().getLatLonBoundsBox().toBBox();
            Consumer<OsmPrimitive> consumer = AutoFilterManager.getTagValuesConsumer(key, values);
            ds.searchNodes(bbox).forEach(consumer);
            ds.searchWays(bbox).forEach(consumer);
            ds.searchRelations(bbox).forEach(consumer);
        }
        return values;
    }

    static Consumer<OsmPrimitive> getTagValuesConsumer(String key, Set<String> values) {
        return o -> {
            String value = o.get(key);
            if (value != null) {
                Pattern p = Pattern.compile("(-?[0-9]+)-(-?[0-9]+)");
                for (String v : value.split(";")) {
                    Matcher m = p.matcher(v);
                    if (m.matches()) {
                        int a = Integer.parseInt(m.group(1));
                        int b = Integer.parseInt(m.group(2));
                        for (int i = Math.min(a, b); i <= Math.max(a, b); ++i) {
                            values.add(Integer.toString(i));
                        }
                        continue;
                    }
                    values.add(v);
                }
            }
        };
    }

    @Override
    public void zoomChanged() {
        this.updateButtons();
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.updateFiltersFull();
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        this.updateFiltersFull();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        this.updateFiltersFull();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        this.updateFiltersEvent(event, false);
        this.updateButtons();
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.updateFiltersFull();
        this.updateButtons();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.updateFiltersEvent(event, true);
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        this.updateFiltersEvent(event, true);
        this.updateButtons();
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.updateFiltersEvent(event, true);
    }

    @Override
    public void mapModeChange(MapMode oldMapMode, MapMode newMapMode) {
        this.updateFiltersFull();
    }

    private synchronized void updateFiltersFull() {
        if (this.currentAutoFilter != null) {
            this.model.executeFilters();
        }
    }

    private synchronized void updateFiltersEvent(AbstractDatasetChangedEvent event, boolean affectedOnly) {
        if (this.currentAutoFilter != null) {
            Collection<? extends OsmPrimitive> prims = event.getPrimitives();
            this.model.executeFilters(affectedOnly ? FilterModel.getAffectedPrimitives(prims) : prims);
        }
    }

    public synchronized boolean registerAutoFilterRules(AutoFilterRule ... filterRules) {
        return this.rules.addAll(Arrays.asList(filterRules));
    }

    public synchronized boolean unregisterAutoFilterRule(AutoFilterRule rule) {
        return this.rules.remove(Objects.requireNonNull(rule, "rule"));
    }

    public synchronized List<AutoFilterRule> getAutoFilterRules() {
        return new ArrayList<AutoFilterRule>(this.rules);
    }

    public synchronized AutoFilterRule getAutoFilterRule(String key) {
        for (AutoFilterRule r : this.rules) {
            if (!key.equals(r.getKey())) continue;
            return r;
        }
        return null;
    }

    public synchronized void enableAutoFilterRule(String key) {
        this.enableAutoFilterRule(key == null ? null : this.getAutoFilterRule(key));
    }

    public synchronized void enableAutoFilterRule(AutoFilterRule rule) {
        this.enabledRule = rule;
    }

    public synchronized AutoFilter getCurrentAutoFilter() {
        return this.currentAutoFilter;
    }

    public synchronized void setCurrentAutoFilter(AutoFilter autoFilter) {
        this.model.clearFilters();
        this.currentAutoFilter = autoFilter;
        if (autoFilter != null) {
            OsmDataLayer dataLayer;
            this.model.addFilter(autoFilter.getFilter());
            this.model.executeFilters();
            if (this.model.isChanged() && (dataLayer = MainApplication.getLayerManager().getActiveDataLayer()) != null) {
                dataLayer.invalidate();
            }
        }
    }

    public synchronized void drawOSDText(Graphics2D g) {
        this.model.drawOSDText(g, this.lblOSD, I18n.tr("<h2>Filter active: {0}</h2>", this.currentAutoFilter.getFilter().text), I18n.tr("</p><p>Click again on filter button to see all objects.</p></html>", new Object[0]));
    }

    private void resetCurrentAutoFilter() {
        this.setCurrentAutoFilter(null);
        this.removeAllButtons();
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.filterDialog.getFilterModel().executeFilters(true);
        }
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e.getKey().equals(PROP_AUTO_FILTER_ENABLED.getKey())) {
            if (PROP_AUTO_FILTER_ENABLED.get().booleanValue()) {
                this.enableAutoFilterRule(PROP_AUTO_FILTER_RULE.get());
                this.updateButtons();
            } else {
                this.enableAutoFilterRule((AutoFilterRule)null);
                this.resetCurrentAutoFilter();
            }
        } else if (e.getKey().equals(PROP_AUTO_FILTER_RULE.getKey())) {
            this.enableAutoFilterRule(PROP_AUTO_FILTER_RULE.get());
            this.resetCurrentAutoFilter();
            this.updateButtons();
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (MainApplication.getLayerManager().getActiveDataLayer() == null) {
            this.resetCurrentAutoFilter();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }
}

