/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java2d.CloningFeature;
import java2d.CustomControlsContext;
import java2d.DemoFonts;
import java2d.DemoGroup;
import java2d.DemoImages;
import java2d.DemoInstVarsAccessor;
import java2d.DemoPanel;
import java2d.GlobalControls;
import java2d.GlobalPanel;
import java2d.Intro;
import java2d.MemoryMonitor;
import java2d.PerformanceMonitor;
import java2d.RunWindow;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;

public class J2Ddemo
extends JPanel
implements ItemListener,
ActionListener,
DemoInstVarsAccessor {
    private final GlobalControls controls;
    private final MemoryMonitor memorymonitor;
    private final PerformanceMonitor performancemonitor;
    private final JTabbedPane tabbedPane;
    private final DemoGroup[] group;
    private JCheckBoxMenuItem verboseCB;
    private JCheckBoxMenuItem ccthreadCB;
    private JCheckBoxMenuItem printCB = new JCheckBoxMenuItem("Default Printer");
    private Color backgroundColor;
    private JCheckBoxMenuItem memoryCB;
    private JCheckBoxMenuItem perfCB;
    private final Intro intro;
    public static final String[][] demos = new String[][]{{"Arcs_Curves", "Arcs", "BezierAnim", "Curves", "Ellipses"}, {"Clipping", "Areas", "ClipAnim", "Intersection", "Text"}, {"Colors", "BullsEye", "ColorConvert", "Rotator3D"}, {"Composite", "ACimages", "ACrules", "FadeAnim"}, {"Fonts", "AttributedStr", "Highlighting", "Outline", "Tree"}, {"Images", "DukeAnim", "ImageOps", "JPEGFlip", "WarpImage"}, {"Lines", "Caps", "Dash", "Joins", "LineAnim"}, {"Mix", "Balls", "BezierScroller", "Stars3D"}, {"Paint", "GradAnim", "Gradient", "Texture", "TextureAnim"}, {"Paths", "Append", "CurveQuadTo", "FillStroke", "WindingRule"}, {"Transforms", "Rotate", "SelectTx", "TransformAnim"}};
    private final boolean demoIsInApplet;
    private JCheckBoxMenuItem controlsCB;
    private JMenuItem runMI;
    private JMenuItem cloneMI;
    private JMenuItem fileMI;
    private JMenuItem backgMI;
    private RunWindow runwindow;
    private RunWindow.RunWindowSettings runWndSetts;
    private CloningFeature cloningfeature;
    private JFrame rf;
    private JFrame cf;

    public J2Ddemo(boolean demoIsInApplet, DemoProgress progress, RunWindow.RunWindowSettings runWndSetts) {
        this.demoIsInApplet = demoIsInApplet;
        this.runWndSetts = runWndSetts;
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.add((Component)this.createMenuBar(), "North");
        progress.setMaximum(13);
        progress.setText("Loading images");
        DemoImages.newDemoImages();
        progress.setValue(progress.getValue() + 1);
        progress.setText("Loading fonts");
        DemoFonts.newDemoFonts();
        progress.setValue(progress.getValue() + 1);
        progress.setText("Loading Intro");
        this.intro = new Intro();
        progress.setValue(progress.getValue() + 1);
        UIManager.put("Button.margin", new Insets(0, 0, 0, 0));
        this.controls = new GlobalControls(this);
        this.memorymonitor = new MemoryMonitor();
        this.performancemonitor = new PerformanceMonitor();
        GlobalPanel gp = new GlobalPanel(this);
        this.tabbedPane = new JTabbedPane(1, 0);
        this.tabbedPane.setFont(new Font("Serif", 0, 12));
        this.tabbedPane.addTab("", new J2DIcon(this), gp);
        this.tabbedPane.addChangeListener(gp);
        this.group = new DemoGroup[demos.length];
        for (int i = 0; i < demos.length; ++i) {
            progress.setText("Loading demos." + demos[i][0]);
            this.group[i] = new DemoGroup(demos[i][0], this);
            this.tabbedPane.addTab(demos[i][0], null);
            progress.setValue(progress.getValue() + 1);
        }
        this.add((Component)this.tabbedPane, "Center");
    }

    private JMenuBar createMenuBar() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar menuBar = new JMenuBar();
        if (!this.demoIsInApplet) {
            JMenu file = menuBar.add(new JMenu("File"));
            this.fileMI = file.add(new JMenuItem("Exit"));
            this.fileMI.addActionListener(this);
        }
        JMenu options = menuBar.add(new JMenu("Options"));
        this.controlsCB = (JCheckBoxMenuItem)options.add(new JCheckBoxMenuItem("Global Controls", true));
        this.controlsCB.addItemListener(this);
        this.memoryCB = (JCheckBoxMenuItem)options.add(new JCheckBoxMenuItem("Memory Monitor", true));
        this.memoryCB.addItemListener(this);
        this.perfCB = (JCheckBoxMenuItem)options.add(new JCheckBoxMenuItem("Performance Monitor", true));
        this.perfCB.addItemListener(this);
        options.add(new JSeparator());
        this.ccthreadCB = (JCheckBoxMenuItem)options.add(new JCheckBoxMenuItem("Custom Controls Thread"));
        this.ccthreadCB.addItemListener(this);
        this.printCB = (JCheckBoxMenuItem)options.add(this.printCB);
        this.verboseCB = (JCheckBoxMenuItem)options.add(new JCheckBoxMenuItem("Verbose"));
        options.add(new JSeparator());
        this.backgMI = options.add(new JMenuItem("Background Color"));
        this.backgMI.addActionListener(this);
        this.runMI = options.add(new JMenuItem("Run Window"));
        this.runMI.addActionListener(this);
        this.cloneMI = options.add(new JMenuItem("Cloning Feature"));
        this.cloneMI.addActionListener(this);
        return menuBar;
    }

    public void createRunWindow() {
        if (this.rf != null) {
            this.rf.toFront();
            return;
        }
        this.runwindow = new RunWindow(this, this.runWndSetts);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                J2Ddemo.this.runwindow.stop();
                J2Ddemo.this.rf.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                J2Ddemo.this.rf = null;
            }
        };
        this.rf = new JFrame("Run");
        this.rf.addWindowListener(l);
        this.rf.getContentPane().add("Center", this.runwindow);
        this.rf.pack();
        if (!this.demoIsInApplet) {
            this.rf.setSize(new Dimension(200, 125));
        } else {
            this.rf.setSize(new Dimension(200, 150));
        }
        this.rf.setVisible(true);
    }

    public void startRunWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                J2Ddemo.this.runwindow.doRunAction();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.fileMI)) {
            System.exit(0);
        } else if (e.getSource().equals(this.runMI)) {
            this.createRunWindow();
        } else if (e.getSource().equals(this.cloneMI)) {
            if (this.cloningfeature == null) {
                this.cloningfeature = new CloningFeature(this);
                WindowAdapter l = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        J2Ddemo.this.cloningfeature.stop();
                        J2Ddemo.this.cf.dispose();
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        J2Ddemo.this.cloningfeature = null;
                    }
                };
                this.cf = new JFrame("Cloning Demo");
                this.cf.addWindowListener(l);
                this.cf.getContentPane().add("Center", this.cloningfeature);
                this.cf.pack();
                this.cf.setSize(new Dimension(320, 330));
                this.cf.setVisible(true);
            } else {
                this.cf.toFront();
            }
        } else if (e.getSource().equals(this.backgMI)) {
            this.backgroundColor = JColorChooser.showDialog(this, "Background Color", Color.white);
            for (int i = 1; i < this.tabbedPane.getTabCount(); ++i) {
                JPanel p = this.group[i - 1].getPanel();
                for (int j = 0; j < p.getComponentCount(); ++j) {
                    DemoPanel dp = (DemoPanel)p.getComponent(j);
                    if (dp.surface == null) continue;
                    dp.surface.setBackground(this.backgroundColor);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.controlsCB)) {
            boolean newVisibility = !this.controls.isVisible();
            this.controls.setVisible(newVisibility);
            for (Component cmp : this.controls.texturechooser.getComponents()) {
                cmp.setVisible(newVisibility);
            }
        } else if (e.getSource().equals(this.memoryCB)) {
            if (this.memorymonitor.isVisible()) {
                this.memorymonitor.setVisible(false);
                this.memorymonitor.surf.setVisible(false);
                this.memorymonitor.surf.stop();
            } else {
                this.memorymonitor.setVisible(true);
                this.memorymonitor.surf.setVisible(true);
                this.memorymonitor.surf.start();
            }
        } else if (e.getSource().equals(this.perfCB)) {
            if (this.performancemonitor.isVisible()) {
                this.performancemonitor.setVisible(false);
                this.performancemonitor.surf.setVisible(false);
                this.performancemonitor.surf.stop();
            } else {
                this.performancemonitor.setVisible(true);
                this.performancemonitor.surf.setVisible(true);
                this.performancemonitor.surf.start();
            }
        } else if (e.getSource().equals(this.ccthreadCB)) {
            CustomControlsContext.State state;
            CustomControlsContext.State state2 = state = this.ccthreadCB.isSelected() ? CustomControlsContext.State.START : CustomControlsContext.State.STOP;
            if (this.tabbedPane.getSelectedIndex() != 0) {
                JPanel p = this.group[this.tabbedPane.getSelectedIndex() - 1].getPanel();
                for (int i = 0; i < p.getComponentCount(); ++i) {
                    DemoPanel dp = (DemoPanel)p.getComponent(i);
                    if (dp.ccc == null) continue;
                    dp.ccc.handleThread(state);
                }
            }
        }
        this.revalidate();
    }

    public void start() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.intro.start();
        } else {
            this.group[this.tabbedPane.getSelectedIndex() - 1].setup(false);
            if (this.memorymonitor.surf.thread == null && this.memoryCB.getState()) {
                this.memorymonitor.surf.start();
            }
            if (this.performancemonitor.surf.thread == null && this.perfCB.getState()) {
                this.performancemonitor.surf.start();
            }
        }
    }

    public void stop() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.intro.stop();
        } else {
            this.memorymonitor.surf.stop();
            this.performancemonitor.surf.stop();
            int i = this.tabbedPane.getSelectedIndex() - 1;
            this.group[i].shutDown(this.group[i].getPanel());
        }
    }

    @Override
    public GlobalControls getControls() {
        return this.controls;
    }

    @Override
    public MemoryMonitor getMemoryMonitor() {
        return this.memorymonitor;
    }

    @Override
    public PerformanceMonitor getPerformanceMonitor() {
        return this.performancemonitor;
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public DemoGroup[] getGroup() {
        return this.group;
    }

    @Override
    public void setGroupColumns(int columns) {
        for (DemoGroup dg : this.group) {
            if (dg == null) continue;
            dg.columns = columns;
        }
    }

    @Override
    public JCheckBoxMenuItem getVerboseCB() {
        return this.verboseCB;
    }

    @Override
    public JCheckBoxMenuItem getCcthreadCB() {
        return this.ccthreadCB;
    }

    @Override
    public JCheckBoxMenuItem getPrintCB() {
        return this.printCB;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public JCheckBoxMenuItem getMemoryCB() {
        return this.memoryCB;
    }

    @Override
    public JCheckBoxMenuItem getPerfCB() {
        return this.perfCB;
    }

    @Override
    public Intro getIntro() {
        return this.intro;
    }

    static void addToGridBag(JPanel panel, Component comp, int x, int y, int w, int h, double weightx, double weighty) {
        GridBagLayout gbl = (GridBagLayout)panel.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.gridheight = h;
        c.weightx = weightx;
        c.weighty = weighty;
        panel.add(comp);
        gbl.setConstraints(comp, c);
    }

    private static void initFrame(String[] args, RunWindow.RunWindowSettings runWndSetts) {
        J2Ddemo demo;
        final J2Ddemo[] demoOneInstArr = new J2Ddemo[1];
        JFrame frame = new JFrame("Java 2D(TM) Demo");
        frame.getAccessibleContext().setAccessibleDescription("A sample application to demonstrate Java2D(TM) features");
        int FRAME_WIDTH = 400;
        int FRAME_HEIGHT = 200;
        frame.setSize(FRAME_WIDTH, FRAME_HEIGHT);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(d.width / 2 - FRAME_WIDTH / 2, d.height / 2 - FRAME_HEIGHT / 2);
        frame.setCursor(Cursor.getPredefinedCursor(3));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                J2Ddemo demo = demoOneInstArr[0];
                if (demo != null) {
                    demo.start();
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
                J2Ddemo demo = demoOneInstArr[0];
                if (demo != null) {
                    demo.stop();
                }
            }
        });
        JOptionPane.setRootFrame(frame);
        JPanel progressPanel = new JPanel(){

            @Override
            public Insets getInsets() {
                return new Insets(40, 30, 20, 30);
            }
        };
        progressPanel.setLayout(new BoxLayout(progressPanel, 1));
        frame.getContentPane().add((Component)progressPanel, "Center");
        Dimension labelSize = new Dimension(400, 20);
        JLabel progressLabel = new JLabel("Loading, please wait...");
        progressLabel.setAlignmentX(0.5f);
        progressLabel.setMaximumSize(labelSize);
        progressLabel.setPreferredSize(labelSize);
        progressPanel.add(progressLabel);
        progressPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        progressLabel.setLabelFor(progressBar);
        progressBar.setAlignmentX(0.5f);
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        progressBar.getAccessibleContext().setAccessibleName("J2D demo loading progress");
        progressPanel.add(progressBar);
        DemoProgress demoProgress = new DemoProgress(progressLabel, progressBar);
        frame.setVisible(true);
        demoOneInstArr[0] = demo = new J2Ddemo(false, demoProgress, runWndSetts);
        frame.getContentPane().removeAll();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)demo, "Center");
        FRAME_WIDTH = 850;
        FRAME_HEIGHT = 600;
        frame.setLocation(d.width / 2 - FRAME_WIDTH / 2, d.height / 2 - FRAME_HEIGHT / 2);
        frame.setSize(FRAME_WIDTH, FRAME_HEIGHT);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String s = arg.substring(arg.indexOf(61) + 1);
            if (arg.startsWith("-runs=")) {
                runWndSetts.setNumRuns(Integer.parseInt(s));
                runWndSetts.setExit(true);
                demo.createRunWindow();
                continue;
            }
            if (arg.startsWith("-screen=")) {
                demo.getControls().screenCombo.setSelectedIndex(Integer.parseInt(s));
                continue;
            }
            if (arg.startsWith("-antialias=")) {
                demo.controls.aliasCB.setSelected(s.endsWith("true"));
                continue;
            }
            if (arg.startsWith("-rendering=")) {
                demo.controls.renderCB.setSelected(s.endsWith("true"));
                continue;
            }
            if (arg.startsWith("-texture=")) {
                demo.controls.textureCB.setSelected(s.endsWith("true"));
                continue;
            }
            if (arg.startsWith("-composite=")) {
                demo.controls.compositeCB.setSelected(s.endsWith("true"));
                continue;
            }
            if (arg.startsWith("-verbose")) {
                demo.verboseCB.setSelected(true);
                continue;
            }
            if (arg.startsWith("-print")) {
                demo.printCB.setSelected(true);
                runWndSetts.setPrintCBIsSelected(true);
                continue;
            }
            if (arg.startsWith("-columns=")) {
                demo.setGroupColumns(Integer.parseInt(s));
                continue;
            }
            if (arg.startsWith("-buffers=")) {
                runWndSetts.setBuffersFlag(true);
                int i1 = arg.indexOf(61) + 1;
                int i2 = arg.indexOf(44);
                String s1 = arg.substring(i1, i2);
                runWndSetts.setBufBeg(Integer.parseInt(s1));
                s1 = arg.substring(i2 + 1, arg.length());
                runWndSetts.setBufEnd(Integer.parseInt(s1));
                continue;
            }
            if (arg.startsWith("-ccthread")) {
                demo.ccthreadCB.setSelected(true);
                continue;
            }
            if (arg.startsWith("-zoom")) {
                runWndSetts.setZoomCBSelected(true);
                continue;
            }
            if (!arg.startsWith("-maxscreen")) continue;
            frame.setLocation(0, 0);
            frame.setSize(d.width, d.height);
        }
        frame.validate();
        frame.repaint();
        frame.getFocusTraversalPolicy().getDefaultComponent(frame).requestFocus();
        demo.start();
        if (runWndSetts.getExit()) {
            demo.startRunWindow();
        }
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunWindow.RunWindowSettings runWndSetts = new RunWindow.RunWindowSettings();
                for (int i = 0; i < args.length; ++i) {
                    String s;
                    if (args[i].startsWith("-h") || args[i].startsWith("-help")) {
                        s = "\njava -jar J2Ddemo.jar -runs=5 -delay=5 -screen=5 -antialias=true -rendering=true -texture=true -composite=true -verbose -print -columns=3 -buffers=5,10 -ccthread -zoom -maxscreen \n";
                        System.out.println(s);
                        s = "    -runs=5       Number of runs to execute\n    -delay=5      Sleep amount between tabs\n    -antialias=   true or false for antialiasing\n    -rendering=   true or false for quality or speed\n    -texture=     true or false for texturing\n    -composite=   true or false for compositing\n    -verbose      output Surface graphic states \n    -print        during run print the Surface, use the Default Printer\n    -columns=3    # of columns to use in clone layout \n    -screen=3     demos all use this screen type \n    -buffers=5,10 during run - clone to see screens five through ten\n    -ccthread     Invoke the Custom Controls Thread \n    -zoom         mouseClick on surface for zoom in  \n    -maxscreen    take up the entire monitor screen \n";
                        System.out.println(s);
                        s = "Examples : \n    Print all of the demos : \n        java -jar J2Ddemo.jar -runs=1 -delay=60 -print \n    Run zoomed in with custom control thread \n        java -jar J2Ddemo.jar -runs=10 -zoom -ccthread\n";
                        System.out.println(s);
                        System.exit(0);
                        continue;
                    }
                    if (!args[i].startsWith("-delay=")) continue;
                    s = args[i].substring(args[i].indexOf(61) + 1);
                    runWndSetts.setDelay(Integer.parseInt(s));
                }
                J2Ddemo.initFrame(args, runWndSetts);
            }
        });
    }

    public static class DemoProgress {
        private final JLabel progressLabel;
        private final JProgressBar progressBar;

        public DemoProgress(JLabel progressLabel, JProgressBar progressBar) {
            if (progressLabel == null) {
                throw new IllegalArgumentException("null was transferred as 'progressLabel' argument");
            }
            if (progressBar == null) {
                throw new IllegalArgumentException("null was transferred as 'progressBar' argument");
            }
            this.progressLabel = progressLabel;
            this.progressBar = progressBar;
        }

        public void setText(String text) {
            this.progressLabel.setText(text);
        }

        public void setMaximum(int n) {
            this.progressBar.setMaximum(n);
        }

        public int getValue() {
            return this.progressBar.getValue();
        }

        public void setValue(int n) {
            this.progressBar.setValue(n);
        }
    }

    static class J2DIcon
    implements Icon {
        private final DemoInstVarsAccessor demoInstVars;
        private static final Color myBlue = new Color(94, 105, 176);
        private static final Color myBlack = new Color(20, 20, 20);
        private static final Font font = new Font("Serif", 1, 12);
        private FontRenderContext frc = new FontRenderContext(null, true, true);
        private TextLayout tl = new TextLayout("J2D demo", font, this.frc);

        public J2DIcon(DemoInstVarsAccessor demoInstVars) {
            this.demoInstVars = demoInstVars;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(font);
            if (this.demoInstVars.getTabbedPane().getSelectedIndex() == 0) {
                g2.setColor(myBlue);
            } else {
                g2.setColor(myBlack);
            }
            this.tl.draw(g2, x, (float)y + (float)this.tl.getBounds().getHeight());
        }

        @Override
        public int getIconWidth() {
            return (int)this.tl.getAdvance() + 5;
        }

        @Override
        public int getIconHeight() {
            return (int)this.tl.getBounds().getHeight();
        }
    }
}

