/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.sctp;

import sun.nio.ch.sctp.AssociationChange;
import sun.nio.ch.sctp.MessageInfoImpl;
import sun.nio.ch.sctp.PeerAddrChange;
import sun.nio.ch.sctp.SctpNotification;
import sun.nio.ch.sctp.SendFailed;
import sun.nio.ch.sctp.Shutdown;

public class ResultContainer {
    static final int NOTHING = 0;
    static final int MESSAGE = 1;
    static final int SEND_FAILED = 2;
    static final int ASSOCIATION_CHANGED = 3;
    static final int PEER_ADDRESS_CHANGED = 4;
    static final int SHUTDOWN = 5;
    private Object value;
    private int type;

    int type() {
        return this.type;
    }

    boolean hasSomething() {
        return this.type() != 0;
    }

    boolean isNotification() {
        return this.type() != 1 && this.type() != 0;
    }

    void clear() {
        this.type = 0;
        this.value = null;
    }

    SctpNotification notification() {
        assert (this.type() != 1 && this.type() != 0);
        return (SctpNotification)this.value;
    }

    MessageInfoImpl getMessageInfo() {
        assert (this.type() == 1);
        if (this.value instanceof MessageInfoImpl) {
            return (MessageInfoImpl)this.value;
        }
        return null;
    }

    SendFailed getSendFailed() {
        assert (this.type() == 2);
        if (this.value instanceof SendFailed) {
            return (SendFailed)this.value;
        }
        return null;
    }

    AssociationChange getAssociationChanged() {
        assert (this.type() == 3);
        if (this.value instanceof AssociationChange) {
            return (AssociationChange)this.value;
        }
        return null;
    }

    PeerAddrChange getPeerAddressChanged() {
        assert (this.type() == 4);
        if (this.value instanceof PeerAddrChange) {
            return (PeerAddrChange)this.value;
        }
        return null;
    }

    Shutdown getShutdown() {
        assert (this.type() == 5);
        if (this.value instanceof Shutdown) {
            return (Shutdown)this.value;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Type: ");
        switch (this.type) {
            case 0: {
                stringBuilder.append("NOTHING");
                break;
            }
            case 1: {
                stringBuilder.append("MESSAGE");
                break;
            }
            case 2: {
                stringBuilder.append("SEND FAILED");
                break;
            }
            case 3: {
                stringBuilder.append("ASSOCIATION CHANGE");
                break;
            }
            case 4: {
                stringBuilder.append("PEER ADDRESS CHANGE");
                break;
            }
            case 5: {
                stringBuilder.append("SHUTDOWN");
                break;
            }
            default: {
                stringBuilder.append("Unknown result type");
            }
        }
        stringBuilder.append(", Value: ");
        stringBuilder.append(this.value == null ? "null" : this.value.toString());
        return stringBuilder.toString();
    }
}

