/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

final class EventDispatcher
implements Runnable {
    private static final int AUTO_CLOSE_TIME = 5000;
    private final ArrayList eventQueue = new ArrayList();
    private Thread thread = null;
    private final ArrayList<ClipInfo> autoClosingClips = new ArrayList();
    private final ArrayList<LineMonitor> lineMonitors = new ArrayList();
    static final int LINE_MONITOR_TIME = 400;

    EventDispatcher() {
    }

    synchronized void start() {
        if (this.thread == null) {
            this.thread = JSSecurityManager.createThread(this, "Java Sound Event Dispatcher", true, -1, true);
        }
    }

    void processEvent(EventInfo eventInfo) {
        int n = eventInfo.getListenerCount();
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent lineEvent = (LineEvent)eventInfo.getEvent();
            for (int i = 0; i < n; ++i) {
                try {
                    ((LineListener)eventInfo.getListener(i)).update(lineEvent);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)eventInfo.getEvent();
            for (int i = 0; i < n; ++i) {
                try {
                    ((MetaEventListener)eventInfo.getListener(i)).meta(metaMessage);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)eventInfo.getEvent();
            int n2 = shortMessage.getStatus();
            if ((n2 & 0xF0) == 176) {
                for (int i = 0; i < n; ++i) {
                    try {
                        ((ControllerEventListener)eventInfo.getListener(i)).controlChange(shortMessage);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                if (this.eventQueue.size() == 0) {
                    if (this.autoClosingClips.size() > 0 || this.lineMonitors.size() > 0) {
                        int n = 5000;
                        if (this.lineMonitors.size() > 0) {
                            n = 400;
                        }
                        this.wait(n);
                    } else {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.eventQueue.size() > 0) {
                eventInfo = (EventInfo)this.eventQueue.remove(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        } else {
            if (this.autoClosingClips.size() > 0) {
                this.closeAutoClosingClips();
            }
            if (this.lineMonitors.size() > 0) {
                this.monitorLines();
            }
        }
    }

    private synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.add(eventInfo);
        this.notifyAll();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.dispatchEvents();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    void sendAudioEvents(Object object, List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        this.start();
        EventInfo eventInfo = new EventInfo(object, list);
        this.postEvent(eventInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAutoClosingClips() {
        ArrayList<ClipInfo> arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            long l = System.currentTimeMillis();
            for (int i = this.autoClosingClips.size() - 1; i >= 0; --i) {
                ClipInfo clipInfo = this.autoClosingClips.get(i);
                if (!clipInfo.isExpired(l)) continue;
                AutoClosingClip autoClosingClip = clipInfo.getClip();
                if (!autoClosingClip.isOpen() || !autoClosingClip.isAutoClosing()) {
                    this.autoClosingClips.remove(i);
                    continue;
                }
                if (autoClosingClip.isRunning() || autoClosingClip.isActive() || !autoClosingClip.isAutoClosing()) continue;
                autoClosingClip.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAutoClosingClipIndex(AutoClosingClip autoClosingClip) {
        ArrayList<ClipInfo> arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            for (int i = this.autoClosingClips.size() - 1; i >= 0; --i) {
                if (!autoClosingClip.equals(this.autoClosingClips.get(i).getClip())) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoClosingClipOpened(AutoClosingClip autoClosingClip) {
        int n = 0;
        Object object = this.autoClosingClips;
        synchronized (object) {
            n = this.getAutoClosingClipIndex(autoClosingClip);
            if (n == -1) {
                this.autoClosingClips.add(new ClipInfo(autoClosingClip));
            }
        }
        if (n == -1) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoClosingClipClosed(AutoClosingClip autoClosingClip) {
        ArrayList<ClipInfo> arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            int n = this.getAutoClosingClipIndex(autoClosingClip);
            if (n != -1) {
                this.autoClosingClips.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorLines() {
        ArrayList<LineMonitor> arrayList = this.lineMonitors;
        synchronized (arrayList) {
            for (int i = 0; i < this.lineMonitors.size(); ++i) {
                this.lineMonitors.get(i).checkLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLineMonitor(LineMonitor lineMonitor) {
        Object object = this.lineMonitors;
        synchronized (object) {
            if (this.lineMonitors.indexOf(lineMonitor) >= 0) {
                return;
            }
            this.lineMonitors.add(lineMonitor);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLineMonitor(LineMonitor lineMonitor) {
        ArrayList<LineMonitor> arrayList = this.lineMonitors;
        synchronized (arrayList) {
            if (this.lineMonitors.indexOf(lineMonitor) < 0) {
                return;
            }
            this.lineMonitors.remove(lineMonitor);
        }
    }

    static interface LineMonitor {
        public void checkLine();
    }

    private class ClipInfo {
        private final AutoClosingClip clip;
        private final long expiration;

        ClipInfo(AutoClosingClip autoClosingClip) {
            this.clip = autoClosingClip;
            this.expiration = System.currentTimeMillis() + 5000L;
        }

        AutoClosingClip getClip() {
            return this.clip;
        }

        boolean isExpired(long l) {
            return l > this.expiration;
        }
    }

    private class EventInfo {
        private final Object event;
        private final Object[] listeners;

        EventInfo(Object object, List list) {
            this.event = object;
            this.listeners = list.toArray();
        }

        Object getEvent() {
            return this.event;
        }

        int getListenerCount() {
            return this.listeners.length;
        }

        Object getListener(int n) {
            return this.listeners[n];
        }
    }
}

