/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;

public abstract class AIObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(AIObject.class.getName());
    private final AIMain aiMain;
    protected boolean initialized;

    protected AIObject(AIMain aiMain) {
        this.aiMain = aiMain;
        this.initialized = false;
    }

    protected AIObject(AIMain aiMain, String id) {
        this(aiMain);
        if (id != null) {
            this.setId(id);
            aiMain.addAIObject(id, this);
        }
    }

    protected AIObject(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        this(aiMain);
        this.readFromXML(xr);
        this.addAIObjectWithId();
    }

    private final boolean isInitialized() {
        return this.initialized;
    }

    public abstract void setInitialized();

    public final AIMain getAIMain() {
        return this.aiMain;
    }

    public void dispose() {
        this.getAIMain().removeAIObject(this.getId());
    }

    public final boolean isDisposed() {
        return this.getAIMain().getAIObject(this.getId()) == null;
    }

    protected final void addAIObjectWithId() {
        if (this.getId() != null) {
            this.aiMain.addAIObject(this.getId(), this);
        }
    }

    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = Constants.IntegrityType.INTEGRITY_GOOD;
        if (!this.isInitialized()) {
            lb.add("\n  Uninitialized AI Object: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    public Constants.IntegrityType checkIntegrity(boolean fix) {
        return this.checkIntegrity(fix, new LogBuilder(-1));
    }

    @Override
    public final Specification getSpecification() {
        return this.getAIMain().getSpecification();
    }

    @Override
    public final void setSpecification(Specification specification) {
        throw new RuntimeException("Can not set specification: " + this);
    }

    @Override
    public final Game getGame() {
        return this.getAIMain().getGame();
    }

    @Override
    public final void setGame(Game game) {
        throw new RuntimeException("Can not set game: " + this);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        AIObject o = this.copyInCast(other, AIObject.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.initialized = o.isInitialized();
        return true;
    }
}

