/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.BuildingDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeCellRenderer;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.colopedia.ConceptDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.FatherDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.GoodsDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.NationDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.NationTypeDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.ResourcesDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.TerrainDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.UnitDetailPanel;
import net.sf.freecol.common.i18n.Messages;

public final class ColopediaPanel
extends FreeColPanel
implements HyperlinkListener,
TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(ColopediaPanel.class.getName());
    private JPanel listPanel;
    private JPanel detailPanel;
    private JTree tree;
    private Map<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();

    public ColopediaPanel(FreeColClient freeColClient, String id) {
        super(freeColClient, "ColopediaPanelUI", new MigLayout("fill", "[750:, grow, fill]", "[][grow, fill][]"));
        this.add((Component)Utility.localizedHeader("colopedia", Utility.FONTSPEC_TITLE), "span, align center");
        this.listPanel = new MigPanel(new MigLayout("fill"));
        this.listPanel.setOpaque(true);
        this.tree = this.buildTree();
        this.listPanel.add((Component)this.tree, "grow");
        JScrollPane sl = new JScrollPane(this.listPanel, 20, 30){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = ColopediaPanel.this.listPanel.getPreferredSize();
                return new Dimension(preferredSize.width + 32, preferredSize.height);
            }
        };
        sl.getVerticalScrollBar().setUnitIncrement(16);
        sl.getViewport().setOpaque(false);
        this.detailPanel = new MigPanel("ColopediaPanelUI");
        this.detailPanel.setOpaque(true);
        JScrollPane detail = new JScrollPane(this.detailPanel, 20, 31);
        detail.getVerticalScrollBar().setUnitIncrement(16);
        detail.getViewport().setOpaque(false);
        this.select(id);
        int width = this.getImageLibrary().scaleInt(1050);
        int height = this.getImageLibrary().scaleInt(725);
        this.getGUI().restoreSavedSize(this, new Dimension(width, height));
        JSplitPane splitPane = new JSplitPane(1, sl, detail);
        this.add((Component)splitPane, "grow");
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColopediaPanel.this.okButton.doClick();
            }
        });
    }

    public ColopediaPanel(FreeColClient freeColClient) {
        super(freeColClient);
    }

    private JTree buildTree() {
        String name = Messages.message("colopedia");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ColopediaTreeItem(null, null, name, null));
        FreeColClient fcc = this.getFreeColClient();
        new TerrainDetailPanel(fcc, this).addSubTrees(root);
        new ResourcesDetailPanel(fcc, this).addSubTrees(root);
        new GoodsDetailPanel(fcc, this).addSubTrees(root);
        new UnitDetailPanel(fcc, this).addSubTrees(root);
        new BuildingDetailPanel(fcc, this).addSubTrees(root);
        new FatherDetailPanel(fcc, this).addSubTrees(root);
        new NationDetailPanel(fcc, this).addSubTrees(root);
        new NationTypeDetailPanel(fcc, this).addSubTrees(root);
        new ConceptDetailPanel(fcc, this).addSubTrees(root);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new ColopediaTreeCellRenderer(this, this.getImageLibrary()));
        this.tree.setOpaque(false);
        this.tree.addTreeSelectionListener(this);
        Enumeration<TreeNode> allNodes = root.depthFirstEnumeration();
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
            ColopediaTreeItem item = (ColopediaTreeItem)node.getUserObject();
            this.nodeMap.put(item.getId(), node);
        }
        return this.tree;
    }

    public Dimension getListItemIconSize() {
        int width = this.getImageLibrary().scaleInt(ImageLibrary.ICON_SIZE.width * 3 / 2);
        int height = this.getImageLibrary().scaleInt(ImageLibrary.ICON_SIZE.height);
        return new Dimension(width, height);
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            this.showDetails((ColopediaTreeItem)node.getUserObject());
        }
    }

    private void showDetails(ColopediaTreeItem nodeItem) {
        this.detailPanel.removeAll();
        if (nodeItem.getPanelType() != null && nodeItem.getId() != null) {
            nodeItem.getPanelType().buildDetail(nodeItem.getId(), this.detailPanel);
        }
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void select(String id) {
        DefaultMutableTreeNode node = this.nodeMap.get(id);
        if (node == null) {
            logger.warning("Unable to find node with id '" + id + "'.");
        } else {
            TreePath oldPath = this.tree.getSelectionPath();
            if (oldPath != null && oldPath.getParentPath() != null) {
                this.tree.collapsePath(oldPath.getParentPath());
            }
            TreePath newPath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(newPath);
            this.tree.expandPath(newPath);
            this.showDetails((ColopediaTreeItem)node.getUserObject());
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        String[] path;
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED && null != (path = e.getURL().getPath().split("/"))[1]) {
            switch (path[1]) {
                case "id": {
                    this.select(path[2]);
                    break;
                }
                case "action": {
                    this.getFreeColClient().getActionManager().getFreeColAction(path[2]).actionPerformed(null);
                    break;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeComponent(this);
        } else {
            this.select(command);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.detailPanel = null;
        this.listPanel = null;
        this.tree = null;
        this.nodeMap = null;
    }
}

