/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeReservedInstancesListings
extends BaseCmd {
    private static final String RESERVED_INSTANCE = "reserved-instance";
    private static final String RESERVED_INSTANCE_ARG = "RESERVED-INSTANCE";
    private static final String[] RESERVED_INSTANCE_DESC = new String[]{"Limit the offerings returned to those listings which are associated", "with the RESERVED-INSTANCE."};

    public DescribeReservedInstancesListings(String[] args) {
        super("ec2dril", "ec2-describe-reserved-instances-listings");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "LISTING [SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)RESERVED_INSTANCE);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)RESERVED_INSTANCE_ARG);
        OptionBuilder.withDescription((String)DescribeReservedInstancesListings.joinDescription(RESERVED_INSTANCE_DESC));
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("    Returns information about the account's Reserved Instance listings");
        System.out.println("    in the Reserved Instance Marketplace. Information returned includes");
        System.out.println("    the ID of the Reserved Instance with which an instance is");
        System.out.println("    associated. If no parameter is specified with this command,");
        System.out.println("    information about all Reserved Instance listings will be returned.");
        System.out.println("    To only describe a specific listing, define it as LISTING.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(RESERVED_INSTANCE);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeReservedInstancesListings(this.getOptionValue(RESERVED_INSTANCE), this.getOptionString(), this.getFilters(true));
        out.outputReservedInstancesListings(System.out, (List)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeReservedInstancesListings(args).invoke();
    }
}

