/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks.cache.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class DataInputStream {
    private final byte[] myBytes;
    private int myPosition;
    private static final long LOW32 = 0xFFFFFFFFL;

    public DataInputStream(byte[] bytes) {
        this(bytes, 0);
    }

    public DataInputStream(byte[] bytes, int position) {
        this.myBytes = bytes;
        this.myPosition = position;
    }

    public int readInt() {
        int result = DataInputStream.bytesToInt(this.myBytes, this.myPosition);
        this.myPosition += 4;
        return result;
    }

    public long readLong() {
        return (long)this.readInt() & 0xFFFFFFFFL | (long)this.readInt() << 32;
    }

    public String readString() {
        int length = this.readInt();
        try {
            String result = new String(this.myBytes, this.myPosition, length, "UTF-8");
            this.myPosition += length;
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPosition() {
        return this.myPosition;
    }

    public boolean atEnd() {
        return this.myPosition == this.myBytes.length;
    }

    public static void writeString(OutputStream strm, String str) throws IOException {
        if (str == null) {
            assert (false);
            str = "";
        }
        byte[] bytes = str.getBytes("UTF-8");
        DataInputStream.writeInt(strm, bytes.length);
        strm.write(bytes);
    }

    public static void writeInt(OutputStream strm, int value) throws IOException {
        byte[] bytes = new byte[4];
        DataInputStream.intToBytes(value, bytes);
        strm.write(bytes);
    }

    public static void writeLong(OutputStream strm, long value) throws IOException {
        DataInputStream.writeInt(strm, (int)(value & 0xFFFFFFFFFFFFFFFFL));
        DataInputStream.writeInt(strm, (int)(value >> 32 & 0xFFFFFFFFFFFFFFFFL));
    }

    public static void intToBytes(int value, byte[] bytes) {
        assert (bytes.length >= 4);
        bytes[0] = (byte)(value & 0xFF);
        bytes[1] = (byte)(value >> 8 & 0xFF);
        bytes[2] = (byte)(value >> 16 & 0xFF);
        bytes[3] = (byte)(value >> 24 & 0xFF);
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
    }

    public static int bytesToInt(byte[] bytes) {
        return DataInputStream.bytesToInt(bytes, 0);
    }
}

