/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyoutput;

import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.propertyoutput.Messages;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutputData;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutputMeta;

public class PropertyOutput
extends BaseStep
implements StepInterface {
    private PropertyOutputMeta meta;
    private PropertyOutputData data;

    public PropertyOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block16: {
            this.meta = (PropertyOutputMeta)smi;
            this.data = (PropertyOutputData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                if (!this.first) {
                    this.saveProperties(this.data.pro);
                }
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.indexOfKeyField = this.data.inputRowMeta.indexOfValue(this.meta.getKeyField());
                if (this.data.indexOfKeyField < 0) {
                    this.logError(Messages.getString("PropertyOutput.Log.ErrorFindingField", this.meta.getKeyField()));
                    throw new KettleException(Messages.getString("PropertyOutput.Log.ErrorFindingField", this.meta.getKeyField()));
                }
                this.data.indexOfValueField = this.data.inputRowMeta.indexOfValue(this.meta.getValueField());
                if (this.data.indexOfValueField < 0) {
                    this.logError(Messages.getString("PropertyOutput.Log.ErrorFindingField", this.meta.getValueField()));
                    throw new KettleException(Messages.getString("PropertyOutput.Log.ErrorFindingField", this.meta.getValueField()));
                }
                String filename = this.buildFilename();
                if (Const.isEmpty((String)filename)) {
                    this.logError(Messages.getString("PropertyOutput.Log.FilenameEmpty"));
                    throw new KettleException(Messages.getString("PropertyOutput.Log.FilenameEmpty"));
                }
                try {
                    this.data.file = KettleVFS.getFileObject((String)filename);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
                this.createParentFolder();
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            String propkey = null;
            String propvalue = null;
            if (this.data.indexOfKeyField > -1) {
                propkey = this.data.inputRowMeta.getString(r, this.data.indexOfKeyField);
            }
            if (this.data.indexOfValueField > -1) {
                propvalue = this.data.inputRowMeta.getString(r, this.data.indexOfValueField);
            }
            try {
                if (!this.data.KeySet.contains(propkey)) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), Messages.getString("PropertyOutput.Log.Key", propkey), new Object[0]);
                        this.log.logDetailed(this.toString(), Messages.getString("PropertyOutput.Log.Value", propvalue), new Object[0]);
                    }
                    this.data.pro.setProperty(propkey, propvalue);
                    this.putRow(this.data.outputRowMeta, r);
                    this.incrementLinesOutput();
                    if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                        this.logBasic("linenr " + this.getLinesRead());
                    }
                    this.data.KeySet.add(propkey);
                }
            }
            catch (KettleStepException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("PropertyOutputMeta.Log.ErrorInStep") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block16;
                this.putError(this.data.outputRowMeta, r, 1L, errorMessage, null, "PROPSOUTPUTO001");
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createParentFolder() throws KettleException {
        if (!this.meta.isCreateParentFolder()) return;
        FileObject parentfolder = null;
        try {
            block10: {
                try {
                    parentfolder = this.data.file.getParent();
                    if (parentfolder.exists()) break block10;
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), Messages.getString("PropertyOutput.Log.ParentFolderExists", parentfolder.getName().toString()), new Object[0]);
                    }
                    parentfolder.createFolder();
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), Messages.getString("PropertyOutput.Log.CanNotCreateParentFolder", parentfolder.getName().toString()), new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.logError(Messages.getString("PropertyOutput.Log.CanNotCreateParentFolder", parentfolder.getName().toString()));
                    throw new KettleException(Messages.getString("PropertyOutput.Log.CanNotCreateParentFolder", parentfolder.getName().toString()));
                }
            }
            Object var4_2 = null;
            if (parentfolder == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (parentfolder == null) throw throwable;
            try {
                parentfolder.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        parentfolder.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveProperties(Properties p) throws KettleException {
        OutputStream propsFile = null;
        try {
            try {
                propsFile = KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false);
                p.store(propsFile, this.environmentSubstitute(this.meta.getComment()));
                if (this.meta.AddToResult()) {
                    ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment(Messages.getString("PropertyOutput.Log.FileAddedResult"));
                    this.addResultFile(resultFile);
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            Object var5_5 = null;
            if (propsFile == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (propsFile == null) throw throwable;
            try {
                propsFile.close();
                propsFile = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        propsFile.close();
        return;
    }

    public String buildFilename() {
        return this.meta.buildFilename(this, this.getCopy());
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyOutputMeta)smi;
        this.data = (PropertyOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.KeySet.clear();
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PropertyOutputMeta)smi;
        this.data = (PropertyOutputData)sdi;
        try {
            if (this.data.file != null) {
                this.data.file.close();
                this.data.file = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setOutputDone();
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

