/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen.event;

import ca.sqlpower.swingui.querypen.MouseState;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.PStyledTextEventHandler;
import java.awt.geom.Point2D;
import javax.swing.text.JTextComponent;

public class ExtendedStyledTextEventHandler
extends PStyledTextEventHandler {
    private static final int ALLOWED_MOVEMENT_ON_MOUSE_CLICK = 5;
    private Point2D mousePressed;
    private State mouseState;
    private MouseState pen;

    public ExtendedStyledTextEventHandler(MouseState pen, PCanvas canvas) {
        super(canvas);
        this.pen = pen;
        this.mouseState = State.MOUSE_UP;
    }

    public ExtendedStyledTextEventHandler(MouseState pen, PCanvas canvas, JTextComponent editor) {
        super(canvas, editor);
        this.pen = pen;
        this.mouseState = State.MOUSE_UP;
    }

    public void mousePressed(PInputEvent e) {
        if (this.pen.getMouseState() == MouseState.MouseStates.READY && this.mouseState == State.MOUSE_UP) {
            this.mouseState = State.MOUSE_DOWN;
            this.mousePressed = e.getPosition();
        }
    }

    public void mouseReleased(PInputEvent e) {
        if (this.pen.getMouseState() == MouseState.MouseStates.READY && this.mouseState == State.MOUSE_DOWN) {
            this.mouseState = State.MOUSE_UP;
            if (e.getPosition().distance(this.mousePressed) < 5.0) {
                super.mousePressed(e);
            }
        }
    }

    private static enum State {
        MOUSE_UP,
        MOUSE_DOWN;

    }
}

