/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.diff;

import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.DiffInfo;
import ca.sqlpower.diff.DiffType;
import ca.sqlpower.diff.PropertyChange;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleDiffChunkJSONConverter {
    public static final Logger logger = Logger.getLogger(SimpleDiffChunkJSONConverter.class);

    public static String encode(List<DiffChunk<DiffInfo>> chunks) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (DiffChunk<DiffInfo> chunk : chunks) {
            JSONObject object = new JSONObject();
            object.put("type", chunk.getType().toString());
            JSONArray changes = new JSONArray();
            for (PropertyChange change : chunk.getPropertyChanges()) {
                JSONObject json = new JSONObject();
                json.put("propertyName", change.getPropertyName());
                json.put("oldValue", change.getOldValue());
                json.put("newValue", change.getNewValue());
                changes.put(json);
            }
            object.put("changes", changes);
            JSONObject info = new JSONObject();
            info.put("dataType", chunk.getData().getDataType());
            info.put("name", chunk.getData().getName());
            info.put("depth", chunk.getData().getDepth());
            object.put("info", info);
            jsonArray.put(object);
        }
        return jsonArray.toString();
    }

    public static List<DiffChunk<DiffInfo>> decode(String message) throws JSONException {
        ArrayList<DiffChunk<DiffInfo>> diffChunks = new ArrayList<DiffChunk<DiffInfo>>();
        logger.debug((Object)message);
        JSONArray jsonArray = new JSONArray(message);
        logger.debug((Object)jsonArray.toString());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            JSONObject jsonInfo = object.getJSONObject("info");
            DiffInfo info = new DiffInfo(jsonInfo.getString("dataType"), jsonInfo.getString("name"));
            info.setDepth(jsonInfo.getInt("depth"));
            DiffType type = DiffType.valueOf(object.getString("type"));
            DiffChunk<DiffInfo> chunk = new DiffChunk<DiffInfo>(info, type);
            JSONArray changes = object.getJSONArray("changes");
            for (int j = 0; j < changes.length(); ++j) {
                JSONObject change = changes.getJSONObject(j);
                chunk.addPropertyChange(new PropertyChange(change.getString("propertyName"), change.getString("oldValue"), change.getString("newValue")));
            }
            diffChunks.add(chunk);
        }
        return diffChunks;
    }
}

