'''OpenGL extension EXT.window_rectangles

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.window_rectangles to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides additional orthogonally aligned "window
	rectangles" specified in window-space coordinates that restrict
	rasterization of all primitive types (geometry, images, paths)
	and framebuffer clears.
	
	When rendering to the framebuffer of an on-screen window, these
	window rectangles are ignored so these window rectangles apply to
	rendering to non-zero framebuffer objects only.
	
	From zero to an implementation-dependent limit (specified by
	GL_MAX_WINDOW_RECTANGLES_EXT) number of window rectangles can be
	operational at once.  When one or more window rectangles are active,
	rasterized fragments can either survive if the fragment is within
	any of the operational window rectangles (GL_INCLUSIVE_EXT mode) or
	be rejected if the fragment is within any of the operational window
	rectangles (GL_EXCLUSIVE_EXT mode).
	
	These window rectangles operate orthogonally to the existing scissor
	test functionality.
	
	This extension has specification language for both OpenGL and ES so
	EXT_window_rectangles can be implemented and advertised for either
	or both API contexts.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/window_rectangles.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.window_rectangles import *
from OpenGL.raw.GLES2.EXT.window_rectangles import _EXTENSION_NAME

def glInitWindowRectanglesEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glWindowRectanglesEXT.box size not checked against 'count'
glWindowRectanglesEXT=wrapper.wrapper(glWindowRectanglesEXT).setInputArraySize(
    'box', None
)
### END AUTOGENERATED SECTION