# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the vyos_snmp_server module
"""


class Snmp_serverArgs(object):  # pylint: disable=R0903
    """The arg spec for the vyos_snmp_server module"""

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "communities": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "name": {"type": "str"},
                        "clients": {"type": "list", "elements": "str"},
                        "networks": {"type": "list", "elements": "str"},
                        "authorization_type": {
                            "type": "str",
                            "choices": ["ro", "rw"],
                        },
                    },
                },
                "contact": {"type": "str"},
                "description": {"type": "str"},
                "listen_addresses": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "port": {"type": "int"},
                    },
                },
                "location": {"type": "str"},
                "smux_peer": {"type": "str"},
                "trap_source": {"type": "str"},
                "trap_target": {
                    "type": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "community": {"type": "str"},
                        "port": {"type": "int"},
                    },
                },
                "snmp_v3": {
                    "type": "dict",
                    "options": {
                        "engine_id": {"type": "str"},
                        "groups": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "group": {"type": "str"},
                                "mode": {
                                    "type": "str",
                                    "choices": ["ro", "rw"],
                                },
                                "seclevel": {
                                    "type": "str",
                                    "choices": ["auth", "priv"],
                                },
                                "view": {"type": "str"},
                            },
                        },
                        "trap_targets": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "address": {"type": "str"},
                                "authentication": {
                                    "type": "dict",
                                    "options": {
                                        "type": {
                                            "type": "str",
                                            "choices": ["md5", "sha"],
                                        },
                                        "encrypted_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                        "plaintext_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                    },
                                },
                                "engine_id": {"type": "str"},
                                "port": {"type": "int"},
                                "privacy": {
                                    "type": "dict",
                                    "options": {
                                        "type": {
                                            "type": "str",
                                            "choices": ["des", "aes"],
                                        },
                                        "encrypted_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                        "plaintext_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                    },
                                },
                                "protocol": {
                                    "type": "str",
                                    "choices": ["tcp", "udp"],
                                },
                                "type": {
                                    "type": "str",
                                    "choices": ["inform", "trap"],
                                },
                            },
                        },
                        "tsm": {
                            "type": "dict",
                            "options": {
                                "local_key": {"type": "str", "no_log": True},
                                "port": {"type": "int"},
                            },
                        },
                        "users": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "user": {"type": "str"},
                                "authentication": {
                                    "type": "dict",
                                    "options": {
                                        "type": {
                                            "type": "str",
                                            "choices": ["md5", "sha"],
                                        },
                                        "encrypted_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                        "plaintext_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                    },
                                },
                                "engine_id": {"type": "str"},
                                "group": {"type": "str"},
                                "mode": {
                                    "type": "str",
                                    "choices": ["ro", "rw"],
                                },
                                "privacy": {
                                    "type": "dict",
                                    "options": {
                                        "type": {
                                            "type": "str",
                                            "choices": ["des", "aes"],
                                        },
                                        "encrypted_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                        "plaintext_key": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                    },
                                },
                                "tsm_key": {"type": "str", "no_log": True},
                            },
                        },
                        "views": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "view": {"type": "str"},
                                "oid": {"type": "str"},
                                "exclude": {"type": "str"},
                                "mask": {"type": "str"},
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
