/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.welcome;

import java.awt.BorderLayout;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.graalvm.visualvm.modules.appui.welcome.StartPageContent;
import org.graalvm.visualvm.modules.appui.welcome.WelcomeOptions;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class WelcomeComponent
extends TopComponent {
    static final long serialVersionUID = 6021472310161712674L;
    private static final String PREFERRED_ID = "VisualVMWelcome";
    private static WeakReference<WelcomeComponent> component = new WeakReference<Object>(null);
    private JComponent content;
    private boolean initialized = false;
    private static boolean firstTimeOpen = true;

    private WelcomeComponent() {
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage(WelcomeComponent.class, (String)"LBL_Tab_Title"));
        this.content = null;
        this.initialized = false;
        this.putClientProperty("activateAtStartup", Boolean.TRUE);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void doInitialize() {
        this.initAccessibility();
        if (null == this.content) {
            this.content = new StartPageContent();
            this.add(this.content, "Center");
            this.setFocusable(false);
        }
    }

    public static synchronized WelcomeComponent findComp() {
        WelcomeComponent wc = (WelcomeComponent)((Object)component.get());
        if (wc == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
            if (tc != null) {
                if (tc instanceof WelcomeComponent) {
                    wc = (WelcomeComponent)tc;
                    component = new WeakReference<WelcomeComponent>(wc);
                } else {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + WelcomeComponent.class.getName() + " Returned:" + tc.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    wc = WelcomeComponent.createComp();
                }
            } else {
                wc = WelcomeComponent.createComp();
            }
        }
        return wc;
    }

    public static synchronized WelcomeComponent createComp() {
        WelcomeComponent wc = (WelcomeComponent)((Object)component.get());
        if (wc == null) {
            wc = new WelcomeComponent();
            component = new WeakReference<WelcomeComponent>(wc);
        }
        return wc;
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WelcomeComponent.class, (String)"ACS_Welcome_DESC"));
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        if (null != this.content && this.getComponentCount() == 0) {
            this.add(this.content, "Center");
        }
        super.componentShowing();
    }

    protected void componentOpened() {
        super.componentOpened();
        if (firstTimeOpen) {
            firstTimeOpen = false;
            if (!WelcomeOptions.getDefault().isShowOnStartup()) {
                this.close();
            }
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (null != this.content) {
            this.remove(this.content);
        }
    }

    public void requestFocus() {
        if (null != this.content) {
            this.content.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (null != this.content) {
            return this.content.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }
}

