/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Period;
import org.traccar.model.ExtendedModel;
import org.traccar.storage.QueryIgnore;
import org.traccar.storage.StorageName;

@StorageName(value="tc_calendars")
public class Calendar
extends ExtendedModel {
    private String name;
    private byte[] data;
    private net.fortuna.ical4j.model.Calendar calendar;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        this.calendar = builder.build(new ByteArrayInputStream(data));
        this.data = data;
    }

    @QueryIgnore
    @JsonIgnore
    public net.fortuna.ical4j.model.Calendar getCalendar() {
        return this.calendar;
    }

    public Set<Period<Instant>> findPeriods(Date date) {
        if (this.calendar != null) {
            Period<Instant> period = new Period<Instant>(date.toInstant(), Duration.ZERO);
            return this.calendar.getComponents("VEVENT").stream().flatMap(c -> c.calculateRecurrenceSet(period).stream()).map(p -> new Period<Instant>(Calendar.temporalToInstant(p.getStart()), Calendar.temporalToInstant(p.getEnd()))).collect(Collectors.toUnmodifiableSet());
        }
        return Set.of();
    }

    public boolean checkMoment(Date date) {
        return !this.findPeriods(date).isEmpty();
    }

    private static Instant temporalToInstant(Temporal temporal) {
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toInstant();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toInstant();
        }
        if (temporal instanceof Instant) {
            return (Instant)temporal;
        }
        throw new IllegalArgumentException("Unsupported Temporal type");
    }
}

