/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.HashSet;
import java.util.Set;
import org.jxls.command.CellRefGenerator;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.expression.ExpressionEvaluator;
import org.jxls.transform.SafeSheetNameBuilder;

public class DynamicSheetNameGenerator
implements CellRefGenerator {
    private final String sheetNameExpression;
    private final CellRef startCellRef;
    private final ExpressionEvaluator expressionEvaluator;
    private final Set<String> usedSheetNames = new HashSet<String>();

    public DynamicSheetNameGenerator(String sheetNameExpression, CellRef startCellRef, ExpressionEvaluator expressionEvaluator) {
        this.sheetNameExpression = sheetNameExpression;
        this.startCellRef = startCellRef;
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public CellRef generateCellRef(int index, Context context) {
        String sheetName = (String)this.expressionEvaluator.evaluate(this.sheetNameExpression, context.toMap());
        boolean safeName = false;
        Object builder = context.getVar("SafeSheetNameBuilder");
        if (builder instanceof SafeSheetNameBuilder) {
            sheetName = ((SafeSheetNameBuilder)builder).createSafeSheetName(sheetName, index);
            safeName = true;
        }
        if (sheetName == null) {
            return null;
        }
        if (!safeName && !this.usedSheetNames.add(sheetName)) {
            int i = 1;
            while (true) {
                String newName;
                if (this.usedSheetNames.add(newName = sheetName + '(' + i + ')')) {
                    sheetName = newName;
                    break;
                }
                ++i;
            }
        }
        return new CellRef(sheetName, this.startCellRef.getRow(), this.startCellRef.getCol());
    }
}

