/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core.helpers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.UpdateSummaryEnum;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ShowSummaryArgument
extends AbstractCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"showSummary"};
    public static final CommandArgumentDefinition<UpdateSummaryEnum> SHOW_SUMMARY;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(UpdateSummaryEnum.class);
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        UpdateSummaryEnum argumentValue = commandScope.getArgumentValue(SHOW_SUMMARY);
        commandScope.provideDependency(UpdateSummaryEnum.class, (Object)argumentValue);
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        if (commandDefinition.getPipeline().size() == 1) {
            commandDefinition.setInternal(true);
        }
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        SHOW_SUMMARY = commandBuilder.argument("showSummary", UpdateSummaryEnum.class).description("Type of update results summary to show.  Values can be 'off', 'summary', or 'verbose'.").defaultValue(UpdateSummaryEnum.SUMMARY).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String && !value.equals("")) {
                List<String> validValues = Arrays.asList("OFF", "SUMMARY", "VERBOSE");
                if (!validValues.contains(((String)value).toUpperCase())) {
                    throw new IllegalArgumentException("Illegal value for `showUpdateSummary'.  Valid values are 'OFF', 'SUMMARY', or 'VERBOSE'");
                }
                return UpdateSummaryEnum.valueOf(((String)value).toUpperCase());
            }
            if (value instanceof UpdateSummaryEnum) {
                return (UpdateSummaryEnum)((Object)((Object)value));
            }
            return null;
        }).build();
    }
}

