/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.LocalVariables;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.OperandStack;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.UninitializedObjectType;

public class Frame {
    public static UninitializedObjectType _this;
    private LocalVariables locals;
    private OperandStack stack;

    public Frame(int maxLocals, int maxStack) {
        this.locals = new LocalVariables(maxLocals);
        this.stack = new OperandStack(maxStack);
    }

    public Frame(LocalVariables locals, OperandStack stack) {
        this.locals = locals;
        this.stack = stack;
    }

    protected Object clone() {
        Frame f = new Frame(this.locals.getClone(), this.stack.getClone());
        return f;
    }

    public Frame getClone() {
        return (Frame)this.clone();
    }

    public LocalVariables getLocals() {
        return this.locals;
    }

    public OperandStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Frame)) {
            return false;
        }
        Frame f = (Frame)o;
        return this.stack.equals(f.stack) && this.locals.equals(f.locals);
    }

    public String toString() {
        String s = "Local Variables:\n";
        s = s + this.locals;
        s = s + "OperandStack:\n";
        s = s + this.stack;
        return s;
    }

    static Type merge(Type lhs, Type rhs, boolean errorIfFailed) {
        try {
            if (!(lhs instanceof UninitializedObjectType) && rhs instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (!lhs.equals(rhs) && lhs instanceof UninitializedObjectType && rhs instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (lhs instanceof UninitializedObjectType && !(rhs instanceof UninitializedObjectType)) {
                lhs = ((UninitializedObjectType)lhs).getInitialized();
            }
            if (lhs instanceof ReferenceType && rhs instanceof ReferenceType) {
                if (lhs.equals(rhs)) {
                    return lhs;
                }
                ReferenceType sup = ((ReferenceType)lhs).getFirstCommonSuperclass((ReferenceType)rhs);
                if (sup != null) {
                    return sup;
                }
                throw new AssertionViolatedException("Could not load all the super classes of '" + lhs + "' and '" + rhs + "'.");
            }
            if (lhs instanceof ReturnaddressType && rhs instanceof ReturnaddressType) {
                return lhs;
            }
            if (!lhs.equals(rhs)) {
                if (errorIfFailed) {
                    throw new StructuralCodeConstraintException("Cannot merge different types:" + lhs + " and " + rhs);
                }
                return Type.UNKNOWN;
            }
            return lhs;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e.toString());
        }
    }
}

