/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.PageGroup;
import org.apache.fop.render.afp.modca.PageObject;

public final class Document
extends AbstractNamedAFPObject {
    private static final String DEFAULT_NAME = "DOC00001";
    private ArrayList _objects = new ArrayList();
    private boolean _started = false;
    private boolean _complete = false;

    public Document() {
        this(DEFAULT_NAME);
    }

    public Document(String name) {
        super(name);
    }

    public void addPage(PageObject page) {
        if (!this._objects.contains(page)) {
            this._objects.add(page);
        }
    }

    public void addPageGroup(PageGroup pageGroup) {
        this._objects.add(pageGroup);
    }

    public void endDocument() {
        this._complete = true;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        AbstractAFPObject ao;
        if (!this._started) {
            this.writeStart(os);
            this._started = true;
        }
        Iterator it = this._objects.iterator();
        while (it.hasNext() && ((ao = (AbstractAFPObject)it.next()) instanceof PageObject && ((PageObject)ao).isComplete() || ao instanceof PageGroup && ((PageGroup)ao).isComplete())) {
            ao.writeDataStream(os);
            it.remove();
        }
        if (this._complete) {
            this.writeEnd(os);
        }
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -88;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -88;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }
}

