/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Names$;
import dotty.tools.dotc.util.NameTransformer;
import java.io.Serializable;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class NameTransformer$
implements Serializable {
    private static final int nops;
    private static final String[] op2code;
    private static final NameTransformer.OpCodes[] code2op;
    public static final NameTransformer$ MODULE$;

    private NameTransformer$() {
    }

    static {
        MODULE$ = new NameTransformer$();
        nops = 128;
        int ncodes = 676;
        op2code = new String[nops];
        code2op = new NameTransformer.OpCodes[ncodes];
        MODULE$.enterOp('~', "$tilde");
        MODULE$.enterOp('=', "$eq");
        MODULE$.enterOp('<', "$less");
        MODULE$.enterOp('>', "$greater");
        MODULE$.enterOp('!', "$bang");
        MODULE$.enterOp('#', "$hash");
        MODULE$.enterOp('%', "$percent");
        MODULE$.enterOp('^', "$up");
        MODULE$.enterOp('&', "$amp");
        MODULE$.enterOp('|', "$bar");
        MODULE$.enterOp('*', "$times");
        MODULE$.enterOp('/', "$div");
        MODULE$.enterOp('+', "$plus");
        MODULE$.enterOp('-', "$minus");
        MODULE$.enterOp(':', "$colon");
        MODULE$.enterOp('\\', "$bslash");
        MODULE$.enterOp('?', "$qmark");
        MODULE$.enterOp('@', "$at");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NameTransformer$.class);
    }

    private void enterOp(char op, String code) {
        NameTransformer$.op2code[op] = code;
        int c = (code.charAt(1) - 97) * 26 + code.charAt(2) - 97;
        NameTransformer$.code2op[c] = new NameTransformer.OpCodes(op, code, code2op[c]);
    }

    public Names.SimpleName encode(Names.SimpleName name) {
        StringBuilder buf = null;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.apply(i);
            if (c < nops && op2code[c] != null) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(name.sliceToString(0, i));
                }
                buf.append(op2code[c]);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(name.sliceToString(0, i));
                }
                buf.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("$u%04X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf == null) {
            return name;
        }
        return Names$.MODULE$.termName(buf.toString());
    }

    public Names.SimpleName decode(Names.SimpleName name) {
        StringBuilder buf = null;
        int len = name.length();
        int i = 0;
        while (i < len) {
            char ch1;
            NameTransformer.OpCodes ops = null;
            boolean unicode = false;
            char c = name.apply(i);
            if (c == '$' && i + 2 < len && 'a' <= (ch1 = name.apply(i + 1)) && ch1 <= 'z') {
                char ch2 = name.apply(i + 2);
                if ('a' <= ch2 && ch2 <= 'z') {
                    for (ops = code2op[(ch1 - 97) * 26 + ch2 - 97]; ops != null && !name.startsWith(ops.code(), i); ops = ops.next()) {
                    }
                    if (ops != null) {
                        if (buf == null) {
                            buf = new StringBuilder();
                            buf.append(name.sliceToString(0, i));
                        }
                        buf.append(ops.op());
                        i += ops.code().length();
                    }
                } else if (len - i >= 6 && ch1 == 'u' && (Character.isDigit(ch2) || 'A' <= ch2 && ch2 <= 'F')) {
                    String hex = name.sliceToString(i + 2, i + 6);
                    try {
                        char str = (char)Integer.parseInt(hex, 16);
                        if (buf == null) {
                            buf = new StringBuilder();
                            buf.append(name.sliceToString(0, i));
                        }
                        buf.append(str);
                        i += 6;
                        unicode = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (ops != null || unicode) continue;
            if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        if (buf == null) {
            return name;
        }
        return Names$.MODULE$.termName(buf.toString());
    }
}

