/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.query;

import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.query.LtrRewritableQuery;
import com.o19s.es.ltr.query.LtrRewriteContext;
import com.o19s.es.ltr.ranker.LtrRanker;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.opensearch.ltr.settings.LTRSettings;

public class DerivedExpressionQuery
extends Query
implements LtrRewritableQuery {
    private final FeatureSet features;
    private final Expression expression;
    private final Map<String, Double> queryParamValues;

    public DerivedExpressionQuery(FeatureSet features, Expression expr, Map<String, Double> queryParamValues) {
        this.features = features;
        this.expression = expr;
        this.queryParamValues = queryParamValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        DerivedExpressionQuery that = (DerivedExpressionQuery)obj;
        return Objects.deepEquals(this.expression, that.expression) && Objects.deepEquals(this.features, that.features) && Objects.deepEquals(this.queryParamValues, that.queryParamValues);
    }

    @Override
    public Query ltrRewrite(LtrRewriteContext context) {
        return new FVDerivedExpressionQuery(this, context.getFeatureVectorSupplier());
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.features, this.queryParamValues);
    }

    public String toString(String field) {
        return (field != null ? field : "") + ":fv_query(" + this.expression.sourceText + ")";
    }

    public void visit(QueryVisitor visitor) {
    }

    static final class FVDerivedExpressionQuery
    extends Query {
        private final DerivedExpressionQuery query;
        private final Supplier<LtrRanker.FeatureVector> fvSupplier;

        FVDerivedExpressionQuery(DerivedExpressionQuery query, Supplier<LtrRanker.FeatureVector> fvSupplier) {
            this.query = query;
            this.fvSupplier = fvSupplier;
        }

        public String toString(String field) {
            return this.query.toString();
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            if (!LTRSettings.isLTRPluginEnabled()) {
                throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
            }
            if (!scoreMode.needsScores()) {
                return new ConstantScoreWeight(this.query, boost){

                    public boolean isCacheable(LeafReaderContext ctx) {
                        return true;
                    }

                    public Scorer scorer(LeafReaderContext context) throws IOException {
                        return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, DocIdSetIterator.all((int)context.reader().maxDoc()));
                    }
                };
            }
            return new FVWeight(this);
        }

        public boolean equals(Object obj) {
            assert (false);
            return this.sameClassAs(obj) && Objects.equals(this.query, ((FVDerivedExpressionQuery)((Object)obj)).query) && Objects.equals(this.fvSupplier, ((FVDerivedExpressionQuery)((Object)obj)).fvSupplier);
        }

        public int hashCode() {
            assert (false);
            return Objects.hash(this.classHash(), this.query, this.fvSupplier);
        }

        public void visit(QueryVisitor visitor) {
            this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
        }
    }

    static class FVDoubleValuesSource
    extends DoubleValuesSource {
        private final int ordinal;
        private final Supplier<LtrRanker.FeatureVector> vectorSupplier;

        FVDoubleValuesSource(Supplier<LtrRanker.FeatureVector> vectorSupplier, int ordinal) {
            this.vectorSupplier = vectorSupplier;
            this.ordinal = ordinal;
        }

        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return new DoubleValues(){

                public double doubleValue() throws IOException {
                    assert (vectorSupplier.get() != null);
                    return vectorSupplier.get().getFeatureScore(ordinal);
                }

                public boolean advanceExact(int doc) throws IOException {
                    return true;
                }
            };
        }

        public boolean needsScores() {
            return true;
        }

        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FVDoubleValuesSource that = (FVDoubleValuesSource)((Object)o);
            return this.ordinal == that.ordinal && Objects.equals(this.vectorSupplier, that.vectorSupplier);
        }

        public int hashCode() {
            return Objects.hash(this.ordinal, this.vectorSupplier);
        }

        public String toString() {
            return "FVDoubleValuesSource{ordinal=" + this.ordinal + ", vectorSupplier=" + String.valueOf(this.vectorSupplier) + "}";
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    static class DValScorer
    extends Scorer {
        private final DocIdSetIterator iterator;
        private final DoubleValues values;

        DValScorer(Weight weight, DocIdSetIterator iterator, DoubleValues values) {
            super(weight);
            this.iterator = iterator;
            this.values = values;
        }

        public int docID() {
            return this.iterator.docID();
        }

        public float score() throws IOException {
            this.values.advanceExact(this.docID());
            return (float)this.values.doubleValue();
        }

        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }
    }

    static class FVWeight
    extends Weight {
        private final FeatureSet features;
        private final Expression expression;
        private final Supplier<LtrRanker.FeatureVector> vectorSupplier;
        private final Map<String, Double> queryParamValues;

        FVWeight(FVDerivedExpressionQuery query) {
            super((Query)query.query);
            this.features = query.query.features;
            this.expression = query.query.expression;
            this.queryParamValues = query.query.queryParamValues;
            this.vectorSupplier = query.fvSupplier;
        }

        public void extractTerms(Set<Term> terms) {
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Bindings bindings = new Bindings(){

                public DoubleValuesSource getDoubleValuesSource(String name) {
                    Double queryParamValue = queryParamValues.get(name);
                    if (queryParamValue != null) {
                        return DoubleValuesSource.constant((double)queryParamValue);
                    }
                    return new FVDoubleValuesSource(vectorSupplier, features.featureOrdinal(name));
                }
            };
            DocIdSetIterator iterator = DocIdSetIterator.all((int)context.reader().maxDoc());
            DoubleValuesSource src = this.expression.getDoubleValuesSource(bindings);
            DoubleValues values = src.getValues(context, null);
            return new DValScorer(this, iterator, values);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Bindings bindings = new Bindings(){

                public DoubleValuesSource getDoubleValuesSource(String name) {
                    return new FVDoubleValuesSource(vectorSupplier, features.featureOrdinal(name));
                }
            };
            DoubleValuesSource src = this.expression.getDoubleValuesSource(bindings);
            DoubleValues values = src.getValues(context, null);
            values.advanceExact(doc);
            return Explanation.match((Number)Float.valueOf((float)values.doubleValue()), (String)("Evaluation of derived expression: " + this.expression.sourceText), (Explanation[])new Explanation[0]);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

