/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ResultBulkResponse
extends ActionResponse {
    public static final String RETRY_REQUESTS_JSON_KEY = "retry_requests";
    private List<IndexRequest> retryRequests;

    public ResultBulkResponse(List<IndexRequest> retryRequests) {
        this.retryRequests = retryRequests;
    }

    public ResultBulkResponse() {
        this.retryRequests = null;
    }

    public ResultBulkResponse(StreamInput in) throws IOException {
        int size = in.readInt();
        if (size > 0) {
            this.retryRequests = new ArrayList<IndexRequest>(size);
            for (int i = 0; i < size; ++i) {
                this.retryRequests.add(new IndexRequest(in));
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.retryRequests == null || this.retryRequests.size() == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.retryRequests.size());
            for (IndexRequest result : this.retryRequests) {
                result.writeTo(out);
            }
        }
    }

    public boolean hasFailures() {
        return this.retryRequests != null && this.retryRequests.size() > 0;
    }

    public Optional<List<IndexRequest>> getRetryRequests() {
        return Optional.ofNullable(this.retryRequests);
    }
}

