/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.ad.transport.RCFPollingAction;
import org.opensearch.ad.transport.RCFPollingRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchHits;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.ProfileUtil;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.ResourceNotFoundException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.ProfileName;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.ProfileRequest;
import org.opensearch.timeseries.transport.ProfileResponse;
import org.opensearch.timeseries.transport.ResultResponse;
import org.opensearch.timeseries.transport.handler.ResultBulkIndexingHandler;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.timeseries.util.ExceptionUtil;

public abstract class ExecuteResultResponseRecorder<IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, IndexableResultType extends IndexableResult, ProfileActionType extends ActionType<ProfileResponse>> {
    private static final Logger log = LogManager.getLogger(ExecuteResultResponseRecorder.class);
    protected IndexManagementType indexManagement;
    private ResultBulkIndexingHandler<IndexableResultType, IndexType, IndexManagementType> resultHandler;
    protected TaskManagerType taskManager;
    private DiscoveryNodeFilterer nodeFilter;
    private ThreadPool threadPool;
    private String threadPoolName;
    private Client client;
    private NodeStateManager nodeStateManager;
    private TaskCacheManager taskCacheManager;
    private int rcfMinSamples;
    protected IndexType resultIndex;
    private AnalysisType analysisType;
    private ProfileActionType profileAction;

    public ExecuteResultResponseRecorder(IndexManagementType indexManagement, ResultBulkIndexingHandler<IndexableResultType, IndexType, IndexManagementType> resultHandler, TaskManagerType taskManager, DiscoveryNodeFilterer nodeFilter, ThreadPool threadPool, String threadPoolName, Client client, NodeStateManager nodeStateManager, TaskCacheManager taskCacheManager, int rcfMinSamples, IndexType resultIndex, AnalysisType analysisType, ProfileActionType profileAction) {
        this.indexManagement = indexManagement;
        this.resultHandler = resultHandler;
        this.taskManager = taskManager;
        this.nodeFilter = nodeFilter;
        this.threadPool = threadPool;
        this.threadPoolName = threadPoolName;
        this.client = client;
        this.nodeStateManager = nodeStateManager;
        this.taskCacheManager = taskCacheManager;
        this.rcfMinSamples = rcfMinSamples;
        this.resultIndex = resultIndex;
        this.analysisType = analysisType;
        this.profileAction = profileAction;
    }

    public void indexResult(Instant detectionStartTime, Instant executionStartTime, ResultResponse<IndexableResultType> response, Config config) {
        String configId = config.getId();
        try {
            if (!response.shouldSave()) {
                this.updateRealtimeTask(response, configId);
                return;
            }
            IntervalTimeConfiguration windowDelay = (IntervalTimeConfiguration)config.getWindowDelay();
            Instant dataStartTime = detectionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            Instant dataEndTime = executionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            User user = config.getUser();
            if (response.getError() != null) {
                log.info("Result action run for {} with error {}", (Object)configId, (Object)response.getError());
            }
            List<IndexableResultType> analysisResults = response.toIndexableResults(config, dataStartTime, dataEndTime, executionStartTime, Instant.now(), ((IndexManagement)this.indexManagement).getSchemaVersion(this.resultIndex), user, response.getError());
            String resultIndex = config.getCustomResultIndexOrAlias();
            this.resultHandler.bulk(resultIndex, analysisResults, configId, (ActionListener<BulkResponse>)ActionListener.wrap(r -> {}, exception -> log.error(String.format(Locale.ROOT, "Fail to bulk for %s", configId), (Throwable)exception)));
            this.updateRealtimeTask(response, configId);
        }
        catch (EndRunException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to index result for " + configId, (Throwable)e);
        }
    }

    protected void delayedUpdate(ResultResponse<IndexableResultType> response, String configId) {
        DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
        HashSet<ProfileName> profiles = new HashSet<ProfileName>();
        profiles.add(ProfileName.INIT_PROGRESS);
        ProfileRequest profileRequest = new ProfileRequest(configId, profiles, dataNodes);
        Runnable profileHCInitProgress = () -> this.client.execute(this.profileAction, (ActionRequest)profileRequest, ActionListener.wrap(r -> {
            log.debug("Update latest realtime task for config {}, total updates: {}", (Object)configId, (Object)r.getTotalUpdates());
            this.updateLatestRealtimeTask(configId, null, r.getTotalUpdates(), response.getConfigIntervalInMinutes(), response.getError());
        }, e -> log.error("Failed to update latest realtime task for " + configId, (Throwable)e)));
        if (!((TaskManager)this.taskManager).isHCRealtimeTaskStartInitializing(configId)) {
            this.threadPool.schedule(profileHCInitProgress, new TimeValue(60L, TimeUnit.SECONDS), this.threadPoolName);
        } else {
            profileHCInitProgress.run();
        }
    }

    protected void updateLatestRealtimeTask(String configId, String taskState, Long rcfTotalUpdates, Long configIntervalInMinutes, String error) {
        ActionListener listener = ActionListener.wrap(r -> {
            if (r != null) {
                log.debug("Updated latest realtime task successfully for config {}, taskState: {}", (Object)configId, (Object)taskState);
            }
        }, e -> {
            if (e instanceof ResourceNotFoundException && e.getMessage().contains(CommonMessages.CAN_NOT_FIND_LATEST_TASK)) {
                log.error("Can't find latest realtime task of config " + configId);
                ((TaskManager)this.taskManager).removeRealtimeTaskCache(configId);
            } else {
                log.error("Failed to update latest realtime task for config " + configId, (Throwable)e);
            }
        });
        if (!this.taskCacheManager.hasQueriedResultIndex(configId) && rcfTotalUpdates != null && rcfTotalUpdates < (long)this.rcfMinSamples) {
            this.confirmTotalRCFUpdatesFound(configId, taskState, rcfTotalUpdates, configIntervalInMinutes, error, (ActionListener<Long>)ActionListener.wrap(r -> ((TaskManager)this.taskManager).updateLatestRealtimeTaskOnCoordinatingNode(configId, taskState, (Long)r, configIntervalInMinutes, error, (ActionListener<UpdateResponse>)listener), e -> {
                log.error("Fail to confirm rcf update", (Throwable)e);
                ((TaskManager)this.taskManager).updateLatestRealtimeTaskOnCoordinatingNode(configId, taskState, rcfTotalUpdates, configIntervalInMinutes, error, (ActionListener<UpdateResponse>)listener);
            }));
        } else {
            ((TaskManager)this.taskManager).updateLatestRealtimeTaskOnCoordinatingNode(configId, taskState, rcfTotalUpdates, configIntervalInMinutes, error, (ActionListener<UpdateResponse>)listener);
        }
    }

    public void indexResultException(Instant executeStartTime, Instant executeEndTime, String errorMessage, String taskState, Config config) {
        String configId = config.getId();
        try {
            IntervalTimeConfiguration windowDelay = (IntervalTimeConfiguration)config.getWindowDelay();
            Instant dataStartTime = executeStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            Instant dataEndTime = executeEndTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            User user = config.getUser();
            IndexableResultType resultToSave = this.createErrorResult(configId, dataStartTime, dataEndTime, executeEndTime, errorMessage, user);
            String resultIndexOrAlias = config.getCustomResultIndexOrAlias();
            this.resultHandler.index(resultToSave, configId, resultIndexOrAlias);
            if (errorMessage.contains("No RCF models are available either because RCF models are not ready or all nodes are unresponsive or the system might have bugs.") && !config.isHighCardinality()) {
                this.threadPool.schedule(() -> {
                    RCFPollingRequest request = new RCFPollingRequest(configId);
                    this.client.execute((ActionType)RCFPollingAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(rcfPollResponse -> {
                        long totalUpdates = rcfPollResponse.getTotalUpdates();
                        this.updateLatestRealtimeTask(configId, taskState, totalUpdates, config.getIntervalInMinutes(), totalUpdates > 0L ? "" : errorMessage);
                    }, e -> {
                        log.error("Fail to execute RCFRollingAction", (Throwable)e);
                        this.updateLatestRealtimeTask(configId, taskState, null, null, errorMessage);
                    }));
                }, new TimeValue(60L, TimeUnit.SECONDS), this.threadPoolName);
            } else {
                this.updateLatestRealtimeTask(configId, taskState, null, null, errorMessage);
            }
        }
        catch (Exception e) {
            log.error("Failed to index anomaly result for " + configId, (Throwable)e);
        }
    }

    private void confirmTotalRCFUpdatesFound(String configId, String taskState, Long rcfTotalUpdates, Long configIntervalInMinutes, String error, ActionListener<Long> listener) {
        this.nodeStateManager.getConfig(configId, this.analysisType, (ActionListener<Optional<? extends Config>>)ActionListener.wrap(configOptional -> {
            if (!configOptional.isPresent()) {
                listener.onFailure((Exception)new TimeSeriesException(configId, "fail to get config"));
                return;
            }
            this.nodeStateManager.getJob(configId, (ActionListener<Optional<Job>>)ActionListener.wrap(jobOptional -> {
                if (!jobOptional.isPresent()) {
                    listener.onFailure((Exception)new TimeSeriesException(configId, "fail to get job"));
                    return;
                }
                ProfileUtil.confirmRealtimeInitStatus((Config)configOptional.get(), ((Job)jobOptional.get()).getEnabledTime().toEpochMilli(), this.client, this.analysisType, (ActionListener<SearchResponse>)ActionListener.wrap(searchResponse -> ActionListener.completeWith((ActionListener)listener, () -> {
                    SearchHits hits = searchResponse.getHits();
                    Long correctedTotalUpdates = rcfTotalUpdates;
                    if (hits.getTotalHits().value > 0L) {
                        correctedTotalUpdates = this.rcfMinSamples;
                    }
                    this.taskCacheManager.markResultIndexQueried(configId);
                    return correctedTotalUpdates;
                }), exception -> {
                    if (ExceptionUtil.isIndexNotAvailable(exception)) {
                        this.taskCacheManager.markResultIndexQueried(configId);
                        listener.onResponse((Object)0L);
                    } else {
                        listener.onFailure(exception);
                    }
                }));
            }, e -> listener.onFailure((Exception)new TimeSeriesException(configId, "fail to get job"))));
        }, e -> listener.onFailure((Exception)new TimeSeriesException(configId, "fail to get config"))));
    }

    protected abstract IndexableResultType createErrorResult(String var1, Instant var2, Instant var3, Instant var4, String var5, User var6);

    protected abstract void updateRealtimeTask(ResultResponse<IndexableResultType> var1, String var2);
}

