/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.http_action.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverrides;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesHelper;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.config.setting.handler.ConfigOverridesClusterSettingHandler;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class PerformanceAnalyzerOverridesClusterConfigAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerOverridesClusterConfigAction.class);
    public static final String PA_CONFIG_OVERRIDES_PATH = "/_plugins/_performanceanalyzer/override/cluster/config";
    public static final String LEGACY_PA_CONFIG_OVERRIDES_PATH = "/_opendistro/_performanceanalyzer/override/cluster/config";
    private static final String OVERRIDES_FIELD = "overrides";
    private static final String REASON_FIELD = "reason";
    public static final String OVERRIDE_TRIGGERED_FIELD = "override triggered";
    private static final List<RestHandler.ReplacedRoute> REPLACED_ROUTES = Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/override/cluster/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/override/cluster/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/override/cluster/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/override/cluster/config")));
    private final ConfigOverridesClusterSettingHandler configOverridesClusterSettingHandler;
    private final ConfigOverridesWrapper overridesWrapper;

    public PerformanceAnalyzerOverridesClusterConfigAction(Settings settings, RestController restController, ConfigOverridesClusterSettingHandler configOverridesClusterSettingHandler, ConfigOverridesWrapper overridesWrapper) {
        this.configOverridesClusterSettingHandler = configOverridesClusterSettingHandler;
        this.overridesWrapper = overridesWrapper;
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return REPLACED_ROUTES;
    }

    public String getName() {
        return PerformanceAnalyzerOverridesClusterConfigAction.class.getSimpleName();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        BaseRestHandler.RestChannelConsumer consumer;
        if (request.method() == RestRequest.Method.GET) {
            consumer = this.handleGet();
        } else if (request.method() == RestRequest.Method.POST) {
            consumer = this.handlePost(request);
        } else {
            String reason = "Unsupported method:" + request.method().toString() + " Supported: [GET, POST]";
            consumer = this.sendErrorResponse(reason, RestStatus.METHOD_NOT_ALLOWED);
        }
        return consumer;
    }

    private BaseRestHandler.RestChannelConsumer handleGet() {
        return channel -> {
            try {
                ConfigOverrides overrides = this.overridesWrapper.getCurrentClusterConfigOverrides();
                XContentBuilder builder = channel.newBuilder();
                builder.startObject();
                builder.field(OVERRIDES_FIELD, ConfigOverridesHelper.serialize((ConfigOverrides)overrides));
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
            catch (IOException ioe) {
                LOG.error("Error sending response", (Throwable)ioe);
            }
        };
    }

    private BaseRestHandler.RestChannelConsumer handlePost(RestRequest request) throws IOException {
        String jsonString = XContentHelper.convertToJson((BytesReference)request.content(), (boolean)false, (MediaType)XContentType.JSON);
        ConfigOverrides requestedOverrides = ConfigOverridesHelper.deserialize((String)jsonString);
        if (!this.validateOverrides(requestedOverrides)) {
            String reason = "enable set and disable set should be disjoint";
            return this.sendErrorResponse(reason, RestStatus.BAD_REQUEST);
        }
        this.configOverridesClusterSettingHandler.updateConfigOverrides(requestedOverrides);
        return channel -> {
            XContentBuilder builder = channel.newBuilder();
            builder.startObject();
            builder.field(OVERRIDE_TRIGGERED_FIELD, true);
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        };
    }

    private boolean validateOverrides(ConfigOverrides requestedOverrides) {
        boolean isValid = true;
        if (requestedOverrides.getDisable() == null || requestedOverrides.getEnable() == null) {
            return true;
        }
        if (requestedOverrides.getEnable().getRcas() != null && requestedOverrides.getDisable().getRcas() != null) {
            isValid = Collections.disjoint(requestedOverrides.getEnable().getRcas(), requestedOverrides.getDisable().getRcas());
        }
        if (isValid && requestedOverrides.getEnable().getDeciders() != null && requestedOverrides.getDisable().getDeciders() != null) {
            isValid = Collections.disjoint(requestedOverrides.getEnable().getDeciders(), requestedOverrides.getDisable().getDeciders());
        }
        if (isValid && requestedOverrides.getEnable().getActions() != null && requestedOverrides.getDisable().getActions() != null) {
            isValid = Collections.disjoint(requestedOverrides.getEnable().getActions(), requestedOverrides.getDisable().getActions());
        }
        if (isValid && requestedOverrides.getEnable().getCollectors() != null && requestedOverrides.getDisable().getCollectors() != null) {
            isValid = Collections.disjoint(requestedOverrides.getEnable().getCollectors(), requestedOverrides.getDisable().getCollectors());
        }
        return isValid;
    }

    private BaseRestHandler.RestChannelConsumer sendErrorResponse(String reason, RestStatus status) {
        return channel -> {
            XContentBuilder errorBuilder = channel.newErrorBuilder();
            errorBuilder.startObject();
            errorBuilder.field(REASON_FIELD, reason);
            errorBuilder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, errorBuilder));
        };
    }
}

