/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.securityanalytics.action.SearchCustomLogTypeRequest;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSearchCustomLogTypeAction
extends HandledTransportAction<SearchCustomLogTypeRequest, SearchResponse>
implements SecureTransportAction {
    private final Client client;
    private final Settings settings;
    private volatile Boolean filterByEnabled;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final LogTypeService logTypeService;

    @Inject
    public TransportSearchCustomLogTypeAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, ThreadPool threadPool, Settings settings, Client client, LogTypeService logTypeService) {
        super("cluster:admin/opensearch/securityanalytics/logtype/search", transportService, actionFilters, SearchCustomLogTypeRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.logTypeService = logTypeService;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, SearchCustomLogTypeRequest request, final ActionListener<SearchResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        if (this.doFilterForUser(user, this.filterByEnabled)) {
            log.info("Filtering result by: {}", (Object)user.getBackendRoles());
            this.addFilter(user, request.searchRequest().source(), "detector.user.backend_roles.keyword");
        }
        this.threadPool.getThreadContext().stashContext();
        this.logTypeService.searchLogTypes(request.searchRequest(), new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

