/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.action.IndexDetectorAction;
import org.opensearch.securityanalytics.action.IndexDetectorRequest;
import org.opensearch.securityanalytics.action.IndexDetectorResponse;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.DetectorTrigger;

public class RestIndexDetectorAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestIndexDetectorAction.class);

    public String getName() {
        return "index_detector_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/detectors"), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/detectors", "detector_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/detectors"));
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
        if (request.hasParam("refresh")) {
            refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh"));
        }
        String id = request.param("detector_id", "");
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        Detector detector = Detector.parse(xcp, id, null);
        detector.setLastUpdateTime(Instant.now());
        RestIndexDetectorAction.validateDetectorTriggers(detector);
        IndexDetectorRequest indexDetectorRequest = new IndexDetectorRequest(id, refreshPolicy, request.method(), detector);
        return channel -> client.execute((ActionType)IndexDetectorAction.INSTANCE, (ActionRequest)indexDetectorRequest, this.indexDetectorResponse((RestChannel)channel, request.method()));
    }

    private static void validateDetectorTriggers(Detector detector) {
        if (detector.getTriggers() != null) {
            for (DetectorTrigger trigger : detector.getTriggers()) {
                if (trigger.getDetectionTypes().isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Trigger [%s] should mention at least one detection type but found none", trigger.getName()));
                }
                for (String detectionType : trigger.getDetectionTypes()) {
                    if ("threat_intel".equals(detectionType) || "rules".equals(detectionType)) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Trigger [%s] has unsupported detection type [%s]", trigger.getName(), detectionType));
                }
            }
        }
    }

    private RestResponseListener<IndexDetectorResponse> indexDetectorResponse(RestChannel channel, final RestRequest.Method restMethod) {
        return new RestResponseListener<IndexDetectorResponse>(channel){

            public RestResponse buildResponse(IndexDetectorResponse response) throws Exception {
                RestStatus returnStatus = RestStatus.CREATED;
                if (restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (restMethod == RestRequest.Method.POST) {
                    String location = String.format(Locale.getDefault(), "%s/%s", "/_plugins/_security_analytics/detectors", response.getId());
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

