/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrap;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import RawECDHKeyring_Compile.__default;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EphemeralPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.PublicKeyDiscoveryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations_EphemeralPrivateKeyToStaticPublicKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations_PublicKeyDiscovery;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations_RawPrivateKeyToStaticPublicKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, Error>> {
    public DecryptionMaterials _materials = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _senderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public RawEcdhStaticConfigurations _keyAgreementScheme = RawEcdhStaticConfigurations.Default();
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Byte> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, RawEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec) {
        this._materials = materials;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = recipientPublicKey;
        this._senderPublicKey = senderPublicKey;
        this._keyAgreementScheme = keyAgreementScheme;
        this._curveSpec = curveSpec;
    }

    @Override
    public Result<DecryptionMaterials, Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _out6;
        Result<DecryptionMaterials, Error> res = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderId()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider id for AWS KMS ECDH Keyring")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _1_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _2_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _3_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _4_ciphertext = edk.dtor_ciphertext();
        Result<DafnySequence, Error> _5_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _5_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_4_ciphertext, _1_suite);
        if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _6_providerWrappedMaterial = _5_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Error> _7_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _7_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_3_providerInfo.length()).compareTo(Helpers.unsignedToBigInteger((int)Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN())) <= 0 && __default.ValidProviderInfoLength(_3_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_7_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _7_valueOrError2.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        byte _8_keyringVersion = (Byte)_3_providerInfo.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome<Error> _9_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_8_keyringVersion}).equals(__default.RAW__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_9_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _9_valueOrError3.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BigInteger _10_recipientPublicKeyLength = BigInteger.ZERO;
        _10_recipientPublicKeyLength = Helpers.unsignedToBigInteger((int)StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_3_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX())));
        BigInteger _11_recipientPublicKeyLengthIndex = BigInteger.ZERO;
        _11_recipientPublicKeyLengthIndex = Helpers.unsignedToBigInteger((int)Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()).add(_10_recipientPublicKeyLength);
        BigInteger _12_senderPublicKeyIndex = BigInteger.ZERO;
        _12_senderPublicKeyIndex = _11_recipientPublicKeyLengthIndex.add(Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN());
        Outcome<Error> _13_valueOrError4 = Outcome.Default(Error._typeDescriptor());
        _13_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _11_recipientPublicKeyLengthIndex.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(_3_providerInfo.length())) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_13_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _13_valueOrError4.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _14_providerInfoRecipientPublicKey = _3_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.toInt((BigInteger)_11_recipientPublicKeyLengthIndex));
        DafnySequence _15_providerInfoSenderPublicKey = _3_providerInfo.drop(_12_senderPublicKeyIndex);
        Result<DafnySequence, Error> _16_valueOrError5 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = __default.DecompressPublicKey((DafnySequence<? extends Byte>)_15_providerInfoSenderPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _16_valueOrError5 = _out0;
        if (_16_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _16_valueOrError5.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _17_senderPublicKey = _16_valueOrError5.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<DafnySequence, Error> _18_valueOrError6 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out1 = __default.DecompressPublicKey((DafnySequence<? extends Byte>)_14_providerInfoRecipientPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _18_valueOrError6 = _out1;
        if (_18_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _18_valueOrError6.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _19_recipientPublicKey = _18_valueOrError6.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Boolean, Error> _20_valueOrError7 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out2 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_17_senderPublicKey);
        _20_valueOrError7 = _out2;
        if (_20_valueOrError7.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _20_valueOrError7.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _21___v0 = _20_valueOrError7.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<Boolean, Error> _22_valueOrError8 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out3 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_19_recipientPublicKey);
        _22_valueOrError8 = _out3;
        if (_22_valueOrError8.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _22_valueOrError8.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _23___v1 = _22_valueOrError8.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        DafnySequence _24_sharedSecretPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence<? extends Byte> _25_sharedSecretPrivateKey = DafnySequence.empty(uint8._typeDescriptor());
        RawEcdhStaticConfigurations _source0 = this.keyAgreementScheme();
        if (_source0.is_PublicKeyDiscovery()) {
            PublicKeyDiscoveryInput _26___mcc_h0;
            PublicKeyDiscoveryInput _27_publicKeyDiscovery = _26___mcc_h0 = ((RawEcdhStaticConfigurations_PublicKeyDiscovery)_source0)._PublicKeyDiscovery;
            _24_sharedSecretPublicKey = _17_senderPublicKey;
            _25_sharedSecretPrivateKey = _27_publicKeyDiscovery.dtor_recipientStaticPrivateKey();
        } else if (_source0.is_RawPrivateKeyToStaticPublicKey()) {
            RawPrivateKeyToStaticPublicKeyInput _28___mcc_h1;
            RawPrivateKeyToStaticPublicKeyInput _29_rawPrivateKeyToStaticPublicKey = _28___mcc_h1 = ((RawEcdhStaticConfigurations_RawPrivateKeyToStaticPublicKey)_source0)._RawPrivateKeyToStaticPublicKey;
            _25_sharedSecretPrivateKey = _29_rawPrivateKeyToStaticPublicKey.dtor_senderStaticPrivateKey();
            _24_sharedSecretPublicKey = _29_rawPrivateKeyToStaticPublicKey.dtor_recipientPublicKey().equals((Object)_19_recipientPublicKey) ? _19_recipientPublicKey : _17_senderPublicKey;
        } else {
            EphemeralPrivateKeyToStaticPublicKeyInput _30___mcc_h2 = ((RawEcdhStaticConfigurations_EphemeralPrivateKeyToStaticPublicKey)_source0)._EphemeralPrivateKeyToStaticPublicKey;
            res = Result.create_Failure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EphemeralPrivateKeyToStaticPublicKey Not allowed on decrypt")));
            return res;
        }
        Result<Boolean, Error> _31_valueOrError9 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out4 = __default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_24_sharedSecretPublicKey);
        _31_valueOrError9 = _out4;
        if (_31_valueOrError9.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _31_valueOrError9.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _32___v3 = _31_valueOrError9.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<DafnySequence, Error> _33_valueOrError10 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out5 = __default.LocalDeriveSharedSecret(ECCPrivateKey.create(_25_sharedSecretPrivateKey), ECCPublicKey.create((DafnySequence<? extends Byte>)_24_sharedSecretPublicKey), this.curveSpec(), this.cryptoPrimitives());
        _33_valueOrError10 = _out5;
        if (_33_valueOrError10.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _33_valueOrError10.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _34_sharedSecret = _33_valueOrError10.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        EcdhUnwrap _nw0 = new EcdhUnwrap();
        _nw0.__ctor((DafnySequence<? extends Byte>)_15_providerInfoSenderPublicKey, (DafnySequence<? extends Byte>)_14_providerInfoRecipientPublicKey, (DafnySequence<? extends Byte>)_34_sharedSecret, __default.RAW__ECDH__KEYRING__VERSION(), this.curveSpec(), this.cryptoPrimitives());
        EcdhUnwrap _35_ecdhUnwrap = _nw0;
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _36_unwrapOutputRes = _out6 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(EcdhUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _35_ecdhUnwrap);
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _37_valueOrError11 = Result.Default(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), UnwrapEdkMaterialOutput.Default(EcdhUnwrapInfo._typeDescriptor(), EcdhUnwrapInfo.Default()));
        _37_valueOrError11 = _36_unwrapOutputRes;
        if (_37_valueOrError11.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _37_valueOrError11.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<EcdhUnwrapInfo> _38_unwrapOutput = _37_valueOrError11.Extract(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor());
        Result<DecryptionMaterials, Error> _39_valueOrError12 = null;
        _39_valueOrError12 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _38_unwrapOutput.dtor_plaintextDataKey(), _38_unwrapOutput.dtor_symmetricSigningKey());
        if (_39_valueOrError12.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _39_valueOrError12.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _40_result = _39_valueOrError12.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _40_result);
        return res;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public DafnySequence<? extends Byte> senderPublicKey() {
        return this._senderPublicKey;
    }

    public RawEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawECDHKeyring.DecryptSingleEncryptedDataKey";
    }
}

