/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.CryptoMetadata;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public class RepositoryMetadata
implements Writeable {
    public static final Version REPO_GEN_IN_CS_VERSION = LegacyESVersion.V_7_6_0;
    private final String name;
    private final String type;
    private final Settings settings;
    private final CryptoMetadata cryptoMetadata;
    private final long generation;
    private final long pendingGeneration;

    public RepositoryMetadata(String name, String type, Settings settings) {
        this(name, type, settings, -2L, -1L, null);
    }

    public RepositoryMetadata(String name, String type, Settings settings, CryptoMetadata cryptoMetadata) {
        this(name, type, settings, -2L, -1L, cryptoMetadata);
    }

    public RepositoryMetadata(RepositoryMetadata metadata, long generation, long pendingGeneration) {
        this(metadata.name, metadata.type, metadata.settings, generation, pendingGeneration, metadata.cryptoMetadata);
    }

    public RepositoryMetadata(String name, String type, Settings settings, long generation, long pendingGeneration) {
        this(name, type, settings, generation, pendingGeneration, null);
    }

    public RepositoryMetadata(String name, String type, Settings settings, long generation, long pendingGeneration, CryptoMetadata cryptoMetadata) {
        this.name = name;
        this.type = type;
        this.settings = settings;
        this.generation = generation;
        this.pendingGeneration = pendingGeneration;
        assert (generation <= pendingGeneration) : "Pending generation [" + pendingGeneration + "] must be greater or equal to generation [" + generation + "]";
        this.cryptoMetadata = cryptoMetadata;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Settings settings() {
        return this.settings;
    }

    public CryptoMetadata cryptoMetadata() {
        return this.cryptoMetadata;
    }

    public long generation() {
        return this.generation;
    }

    public long pendingGeneration() {
        return this.pendingGeneration;
    }

    public RepositoryMetadata(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        if (in.getVersion().onOrAfter(REPO_GEN_IN_CS_VERSION)) {
            this.generation = in.readLong();
            this.pendingGeneration = in.readLong();
        } else {
            this.generation = -2L;
            this.pendingGeneration = -1L;
        }
        this.cryptoMetadata = in.getVersion().onOrAfter(Version.V_2_10_0) ? (CryptoMetadata)in.readOptionalWriteable(CryptoMetadata::new) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        Settings.writeSettingsToStream(this.settings, out);
        if (out.getVersion().onOrAfter(REPO_GEN_IN_CS_VERSION)) {
            out.writeLong(this.generation);
            out.writeLong(this.pendingGeneration);
        }
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeOptionalWriteable((Writeable)this.cryptoMetadata);
        }
    }

    public boolean equalsIgnoreGenerations(RepositoryMetadata other) {
        return this.name.equals(other.name) && this.type.equals(other.type()) && this.settings.equals(other.settings()) && Objects.equals(this.cryptoMetadata, other.cryptoMetadata());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMetadata that = (RepositoryMetadata)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.generation != that.generation) {
            return false;
        }
        if (this.pendingGeneration != that.pendingGeneration) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return Objects.equals(this.cryptoMetadata, that.cryptoMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.settings, this.generation, this.pendingGeneration, this.cryptoMetadata);
    }

    public String toString() {
        String toStr = "RepositoryMetadata{" + this.name + "}{" + this.type + "}{" + String.valueOf(this.settings) + "}{" + this.generation + "}{" + this.pendingGeneration + "}";
        if (this.cryptoMetadata != null) {
            return toStr + "{" + String.valueOf(this.cryptoMetadata) + "}";
        }
        return toStr;
    }
}

