/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.types.CommandDescriptionImpl;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.types.CommandDescription;
import org.openhab.core.types.CommandDescriptionProvider;
import org.openhab.core.types.CommandOption;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={CommandDescriptionProvider.class})
public class MetadataCommandDescriptionProvider
implements CommandDescriptionProvider {
    private final Logger logger = LoggerFactory.getLogger(MetadataCommandDescriptionProvider.class);
    public static final String COMMANDDESCRIPTION_METADATA_NAMESPACE = "commandDescription";
    private MetadataRegistry metadataRegistry;

    @Activate
    public MetadataCommandDescriptionProvider(@Reference MetadataRegistry metadataRegistry, Map<String, Object> properties) {
        this.metadataRegistry = metadataRegistry;
    }

    @Override
    public @Nullable CommandDescription getCommandDescription(String itemName, @Nullable Locale locale) {
        Metadata metadata = (Metadata)this.metadataRegistry.get(new MetadataKey(COMMANDDESCRIPTION_METADATA_NAMESPACE, itemName));
        if (metadata != null) {
            try {
                CommandDescriptionImpl commandDescription = new CommandDescriptionImpl();
                Object options = metadata.getConfiguration().get("options");
                if (options != null) {
                    Stream.of(options.toString().split(",")).forEach(o -> {
                        if (o.contains("=")) {
                            String[] pair = MetadataCommandDescriptionProvider.parseValueLabelPair(o.trim());
                            commandDescription.addCommandOption(new CommandOption(pair[0], pair[1]));
                        } else {
                            commandDescription.addCommandOption(new CommandOption(o.trim(), null));
                        }
                    });
                    return commandDescription;
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to parse the commandDescription from metadata for item {}, ignoring it", (Object)itemName);
                return null;
            }
        }
        return null;
    }

    public static String[] parseValueLabelPair(String text) {
        String label;
        String value;
        if (text.startsWith("\"") && text.contains("\"=\"") && text.endsWith("\"")) {
            String[] parts = text.split("\"=\"");
            value = parts[0].substring(1);
            label = parts[1].substring(0, parts[1].length() - 1);
        } else {
            String[] parts = text.split("=");
            value = parts[0];
            label = parts[1];
        }
        return new String[]{value.trim(), label.trim()};
    }
}

