/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32.coff;

import sun.jvm.hotspot.debugger.win32.coff.COFFFile;
import sun.jvm.hotspot.debugger.win32.coff.COFFFileParser;
import sun.jvm.hotspot.debugger.win32.coff.COFFHeader;
import sun.jvm.hotspot.debugger.win32.coff.DebugDirectory;
import sun.jvm.hotspot.debugger.win32.coff.DebugDirectoryEntry;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSAlignSym;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSGlobalTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSymbolBase;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50Subsection;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SubsectionDirectory;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SubsectionTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SymbolIterator;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SymbolTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeIterator;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeLeafIndices;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeader;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeaderDataDirectories;

public class TestDebugInfo
implements DebugVC50SubsectionTypes,
DebugVC50SymbolTypes,
DebugVC50TypeLeafIndices {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: java TestParser [file name]");
            System.err.println("File name may be an .exe, .dll or .obj");
            System.exit(1);
        }
        try {
            COFFFile file = COFFFileParser.getParser().parse(args[0]);
            if (file.isImage()) {
                System.out.println("PE Image detected.");
            } else {
                System.out.println("PE Image NOT detected, assuming object file.");
            }
            DebugVC50 vc50 = TestDebugInfo.getDebugVC50(file);
            if (vc50 == null) {
                System.out.println("No debug information found.");
                System.exit(1);
            } else {
                System.out.println("Debug information found!");
            }
            DebugVC50SubsectionDirectory dir = vc50.getSubsectionDirectory();
            block25: for (int i = 0; i < dir.getNumEntries(); ++i) {
                DebugVC50Subsection sec = dir.getSubsection(i);
                switch (sec.getSubsectionType()) {
                    case 288: {
                        System.out.println("  SST_MODULE");
                        continue block25;
                    }
                    case 289: {
                        System.out.println("  SST_TYPES");
                        continue block25;
                    }
                    case 290: {
                        System.out.println("  SST_PUBLIC");
                        continue block25;
                    }
                    case 291: {
                        System.out.println("  SST_PUBLIC_SYM");
                        continue block25;
                    }
                    case 292: {
                        System.out.println("  SST_SYMBOLS");
                        continue block25;
                    }
                    case 293: {
                        System.out.println("  SST_ALIGN_SYM");
                        TestDebugInfo.printSymbolTable(((DebugVC50SSAlignSym)sec).getSymbolIterator());
                        continue block25;
                    }
                    case 294: {
                        System.out.println("  SST_SRC_LN_SEG");
                        continue block25;
                    }
                    case 295: {
                        System.out.println("  SST_SRC_MODULE");
                        continue block25;
                    }
                    case 296: {
                        System.out.println("  SST_LIBRARIES");
                        continue block25;
                    }
                    case 297: {
                        System.out.println("  SST_GLOBAL_SYM");
                        TestDebugInfo.printSymbolTable(sec);
                        continue block25;
                    }
                    case 298: {
                        System.out.println("  SST_GLOBAL_PUB");
                        TestDebugInfo.printSymbolTable(sec);
                        continue block25;
                    }
                    case 299: {
                        System.out.println("  SST_GLOBAL_TYPES");
                        TestDebugInfo.printTypeTable(sec);
                        continue block25;
                    }
                    case 300: {
                        System.out.println("  SST_MPC");
                        continue block25;
                    }
                    case 301: {
                        System.out.println("  SST_SEG_MAP");
                        continue block25;
                    }
                    case 302: {
                        System.out.println("  SST_SEG_NAME");
                        continue block25;
                    }
                    case 303: {
                        System.out.println("  SST_PRE_COMP");
                        continue block25;
                    }
                    case 304: {
                        System.out.println("  SST_UNUSED");
                        continue block25;
                    }
                    case 305: {
                        System.out.println("  SST_OFFSET_MAP_16");
                        continue block25;
                    }
                    case 306: {
                        System.out.println("  SST_OFFSET_MAP_32");
                        continue block25;
                    }
                    case 307: {
                        System.out.println("  SST_FILE_INDEX");
                        continue block25;
                    }
                    case 308: {
                        System.out.println("  SST_STATIC_SYM");
                        TestDebugInfo.printSymbolTable(sec);
                        continue block25;
                    }
                    default: {
                        System.out.println("  (Unknown subsection type " + sec.getSubsectionType() + ")");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DebugVC50 getDebugVC50(COFFFile file) {
        COFFHeader header = file.getHeader();
        OptionalHeader opt = header.getOptionalHeader();
        if (opt == null) {
            System.out.println("Optional header not found.");
            return null;
        }
        OptionalHeaderDataDirectories dd = opt.getDataDirectories();
        if (dd == null) {
            System.out.println("Optional header data directories not found.");
            return null;
        }
        DebugDirectory debug = dd.getDebugDirectory();
        if (debug == null) {
            System.out.println("Debug directory not found.");
            return null;
        }
        for (int i = 0; i < debug.getNumEntries(); ++i) {
            DebugDirectoryEntry entry = debug.getEntry(i);
            if (entry.getType() != 2) continue;
            System.out.println("Debug Directory Entry " + i + " has debug type IMAGE_DEBUG_TYPE_CODEVIEW");
            return entry.getDebugVC50();
        }
        return null;
    }

    private static void printSymbolTable(DebugVC50Subsection sec) {
        DebugVC50SSSymbolBase sym = (DebugVC50SSSymbolBase)sec;
        DebugVC50SymbolIterator iter = sym.getSymbolIterator();
        TestDebugInfo.printSymbolTable(iter);
    }

    private static void printSymbolTable(DebugVC50SymbolIterator iter) {
        while (!iter.done()) {
            int type = iter.getType() & 0xFFFF;
            switch (type) {
                case 1: {
                    System.out.println("    S_COMPILE");
                    break;
                }
                case 5: {
                    System.out.println("    S_SSEARCH");
                    break;
                }
                case 6: {
                    System.out.println("    S_END");
                    break;
                }
                case 7: {
                    System.out.println("    S_SKIP");
                    break;
                }
                case 8: {
                    System.out.println("    S_CVRESERVE");
                    break;
                }
                case 9: {
                    System.out.println("    S_OBJNAME");
                    break;
                }
                case 10: {
                    System.out.println("    S_ENDARG");
                    break;
                }
                case 11: {
                    System.out.println("    S_COBOLUDT");
                    break;
                }
                case 12: {
                    System.out.println("    S_MANYREG");
                    break;
                }
                case 13: {
                    System.out.println("    S_RETURN");
                    break;
                }
                case 14: {
                    System.out.println("    S_ENTRYTHIS");
                    break;
                }
                case 4097: {
                    System.out.println("    S_REGISTER");
                    break;
                }
                case 4098: {
                    System.out.println("    S_CONSTANT");
                    break;
                }
                case 4099: {
                    System.out.println("    S_UDT");
                    break;
                }
                case 4100: {
                    System.out.println("    S_COBOLUDT2");
                    break;
                }
                case 4101: {
                    System.out.println("    S_MANYREG2");
                    break;
                }
                case 4102: {
                    System.out.println("    S_BPREL32");
                    break;
                }
                case 4103: {
                    System.out.println("    S_LDATA32");
                    break;
                }
                case 4104: {
                    System.out.println("    S_GDATA32");
                    break;
                }
                case 4105: {
                    System.out.println("    S_PUB32");
                    break;
                }
                case 4106: {
                    System.out.println("    S_LPROC32");
                    break;
                }
                case 4107: {
                    System.out.println("    S_GPROC32");
                    break;
                }
                case 518: {
                    System.out.println("    S_THUNK32");
                    break;
                }
                case 519: {
                    System.out.println("    S_BLOCK32");
                    break;
                }
                case 520: {
                    System.out.println("    S_WITH32");
                    break;
                }
                case 521: {
                    System.out.println("    S_LABEL32");
                    break;
                }
                case 522: {
                    System.out.println("    S_CEXMODEL32");
                    break;
                }
                case 4108: {
                    System.out.println("    S_VFTTABLE32");
                    break;
                }
                case 4109: {
                    System.out.println("    S_REGREL32");
                    break;
                }
                case 4110: {
                    System.out.println("    S_LTHREAD32");
                    break;
                }
                case 4111: {
                    System.out.println("    S_GTHREAD32");
                    break;
                }
                case 4112: {
                    System.out.println("    S_LPROCMIPS");
                    break;
                }
                case 4113: {
                    System.out.println("    S_GPROCMIPS");
                    break;
                }
                case 1024: {
                    System.out.println("    S_PROCREF");
                    break;
                }
                case 1025: {
                    System.out.println("    S_DATAREF");
                    break;
                }
                case 1026: {
                    System.out.println("    S_ALIGN");
                    break;
                }
                default: {
                    System.out.println("    (Unknown symbol type " + type + ")");
                }
            }
            iter.next();
        }
    }

    private static void printTypeTable(DebugVC50Subsection sec) {
        DebugVC50SSGlobalTypes types = (DebugVC50SSGlobalTypes)sec;
        DebugVC50TypeIterator iter = types.getTypeIterator();
        while (!iter.done()) {
            System.out.print("    Type string: ");
            while (!iter.typeStringDone()) {
                int leaf = iter.typeStringLeaf() & 0xFFFF;
                switch (leaf) {
                    case 4097: {
                        System.out.print("LF_MODIFIER ");
                        break;
                    }
                    case 4098: {
                        System.out.print("LF_POINTER ");
                        break;
                    }
                    case 4099: {
                        System.out.print("LF_ARRAY ");
                        break;
                    }
                    case 4100: {
                        System.out.print("LF_CLASS ");
                        break;
                    }
                    case 4101: {
                        System.out.print("LF_STRUCTURE ");
                        break;
                    }
                    case 4102: {
                        System.out.print("LF_UNION ");
                        break;
                    }
                    case 4103: {
                        System.out.print("LF_ENUM ");
                        break;
                    }
                    case 4104: {
                        System.out.print("LF_PROCEDURE ");
                        break;
                    }
                    case 4105: {
                        System.out.print("LF_MFUNCTION ");
                        break;
                    }
                    case 10: {
                        System.out.print("LF_VTSHAPE ");
                        break;
                    }
                    case 4106: {
                        System.out.print("LF_COBOL0 ");
                        break;
                    }
                    case 12: {
                        System.out.print("LF_COBOL1 ");
                        break;
                    }
                    case 4107: {
                        System.out.print("LF_BARRAY ");
                        break;
                    }
                    case 14: {
                        System.out.print("LF_LABEL ");
                        break;
                    }
                    case 15: {
                        System.out.print("LF_NULL ");
                        break;
                    }
                    case 16: {
                        System.out.print("LF_NOTTRAN ");
                        break;
                    }
                    case 4108: {
                        System.out.print("LF_DIMARRAY ");
                        break;
                    }
                    case 4109: {
                        System.out.print("LF_VFTPATH ");
                        break;
                    }
                    case 4110: {
                        System.out.print("LF_PRECOMP ");
                        break;
                    }
                    case 20: {
                        System.out.print("LF_ENDPRECOMP ");
                        break;
                    }
                    case 4111: {
                        System.out.print("LF_OEM ");
                        break;
                    }
                    case 22: {
                        System.out.print("LF_TYPESERVER ");
                        break;
                    }
                    case 4608: {
                        System.out.print("LF_SKIP ");
                        break;
                    }
                    case 4609: {
                        System.out.print("LF_ARGLIST ");
                        break;
                    }
                    case 4610: {
                        System.out.print("LF_DEFARG ");
                        break;
                    }
                    case 4611: {
                        System.out.print("LF_FIELDLIST ");
                        break;
                    }
                    case 4612: {
                        System.out.print("LF_DERIVED ");
                        break;
                    }
                    case 4613: {
                        System.out.print("LF_BITFIELD ");
                        break;
                    }
                    case 4614: {
                        System.out.print("LF_METHODLIST ");
                        break;
                    }
                    case 4615: {
                        System.out.print("LF_DIMCONU ");
                        break;
                    }
                    case 4616: {
                        System.out.print("LF_DIMCONLU ");
                        break;
                    }
                    case 4617: {
                        System.out.print("LF_DIMVARU ");
                        break;
                    }
                    case 4618: {
                        System.out.print("LF_DIMVARLU ");
                        break;
                    }
                    case 524: {
                        System.out.print("LF_REFSYM ");
                        break;
                    }
                    case 5120: {
                        System.out.print("LF_BCLASS ");
                        break;
                    }
                    case 5121: {
                        System.out.print("LF_VBCLASS ");
                        break;
                    }
                    case 5122: {
                        System.out.print("LF_IVBCLASS ");
                        break;
                    }
                    case 1027: {
                        System.out.print("LF_ENUMERATE ");
                        break;
                    }
                    case 5123: {
                        System.out.print("LF_FRIENDFCN ");
                        break;
                    }
                    case 5124: {
                        System.out.print("LF_INDEX ");
                        break;
                    }
                    case 5125: {
                        System.out.print("LF_MEMBER ");
                        System.out.print(iter.getMemberName() + " ");
                        break;
                    }
                    case 5126: {
                        System.out.print("LF_STMEMBER ");
                        break;
                    }
                    case 5127: {
                        System.out.print("LF_METHOD ");
                        System.out.print(iter.getMethodName() + " ");
                        break;
                    }
                    case 5128: {
                        System.out.print("LF_NESTTYPE ");
                        break;
                    }
                    case 5129: {
                        System.out.print("LF_VFUNCTAB ");
                        break;
                    }
                    case 5130: {
                        System.out.print("LF_FRIENDCLS ");
                        break;
                    }
                    case 5131: {
                        System.out.print("LF_ONEMETHOD ");
                        System.out.print(iter.getOneMethodName() + " ");
                        break;
                    }
                    case 5132: {
                        System.out.print("LF_VFUNCOFF ");
                        break;
                    }
                    case 5133: {
                        System.out.print("LF_NESTTYPEEX ");
                        break;
                    }
                    case 5134: {
                        System.out.print("LF_MEMBERMODIFY ");
                        break;
                    }
                    case 32768: {
                        System.out.print("LF_CHAR ");
                        break;
                    }
                    case 32769: {
                        System.out.print("LF_SHORT ");
                        break;
                    }
                    case 32770: {
                        System.out.print("LF_USHORT ");
                        break;
                    }
                    case 32771: {
                        System.out.print("LF_LONG ");
                        break;
                    }
                    case 32772: {
                        System.out.print("LF_ULONG ");
                        break;
                    }
                    case 32773: {
                        System.out.print("LF_REAL32 ");
                        break;
                    }
                    case 32774: {
                        System.out.print("LF_REAL64 ");
                        break;
                    }
                    case 32775: {
                        System.out.print("LF_REAL80 ");
                        break;
                    }
                    case 32776: {
                        System.out.print("LF_REAL128 ");
                        break;
                    }
                    case 32777: {
                        System.out.print("LF_QUADWORD ");
                        break;
                    }
                    case 32778: {
                        System.out.print("LF_UQUADWORD ");
                        break;
                    }
                    case 32779: {
                        System.out.print("LF_REAL48 ");
                        break;
                    }
                    case 32780: {
                        System.out.print("LF_COMPLEX32 ");
                        break;
                    }
                    case 32781: {
                        System.out.print("LF_COMPLEX64 ");
                        break;
                    }
                    case 32782: {
                        System.out.print("LF_COMPLEX80 ");
                        break;
                    }
                    case 32783: {
                        System.out.print("LF_COMPLEX128 ");
                        break;
                    }
                    case 32784: {
                        System.out.print("LF_VARSTRING ");
                        break;
                    }
                    case 240: {
                        System.out.print("LF_PAD0 ");
                        break;
                    }
                    case 241: {
                        System.out.print("LF_PAD1 ");
                        break;
                    }
                    case 242: {
                        System.out.print("LF_PAD2 ");
                        break;
                    }
                    case 243: {
                        System.out.print("LF_PAD3 ");
                        break;
                    }
                    case 244: {
                        System.out.print("LF_PAD4 ");
                        break;
                    }
                    case 245: {
                        System.out.print("LF_PAD5 ");
                        break;
                    }
                    case 246: {
                        System.out.print("LF_PAD6 ");
                        break;
                    }
                    case 247: {
                        System.out.print("LF_PAD7 ");
                        break;
                    }
                    case 248: {
                        System.out.print("LF_PAD8 ");
                        break;
                    }
                    case 249: {
                        System.out.print("LF_PAD9 ");
                        break;
                    }
                    case 250: {
                        System.out.print("LF_PAD10 ");
                        break;
                    }
                    case 251: {
                        System.out.print("LF_PAD11 ");
                        break;
                    }
                    case 252: {
                        System.out.print("LF_PAD12 ");
                        break;
                    }
                    case 253: {
                        System.out.print("LF_PAD13 ");
                        break;
                    }
                    case 254: {
                        System.out.print("LF_PAD14 ");
                        break;
                    }
                    case 255: {
                        System.out.print("LF_PAD15 ");
                        break;
                    }
                    default: {
                        System.out.print("(Unknown leaf " + leaf + ")");
                    }
                }
                iter.typeStringNext();
            }
            System.out.println("");
            iter.next();
        }
    }
}

