/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.GaloisCounterMode;
import com.sun.crypto.provider.SymmetricCipher;
import javax.crypto.IllegalBlockSizeException;

final class GCTR {
    private final SymmetricCipher aes;
    private final byte[] icb;
    private byte[] counter;
    private byte[] counterSave = null;

    GCTR(SymmetricCipher symmetricCipher, byte[] byArray) {
        this.aes = symmetricCipher;
        if (byArray.length != 16) {
            throw new RuntimeException("length of initial counter block (" + byArray.length + ") not equal to AES_BLOCK_SIZE (" + 16 + ")");
        }
        this.icb = byArray;
        this.counter = (byte[])this.icb.clone();
    }

    int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 - n > byArray.length) {
            throw new RuntimeException("input length out of bound");
        }
        if (n2 < 0 || n2 % 16 != 0) {
            throw new RuntimeException("input length unsupported");
        }
        if (byArray2.length - n3 < n2) {
            throw new RuntimeException("output buffer too small");
        }
        byte[] byArray3 = new byte[16];
        int n4 = n2 / 16;
        for (int i = 0; i < n4; ++i) {
            this.aes.encryptBlock(this.counter, 0, byArray3, 0);
            for (int j = 0; j < 16; ++j) {
                int n5 = i * 16 + j;
                byArray2[n3 + n5] = (byte)(byArray[n + n5] ^ byArray3[j]);
            }
            GaloisCounterMode.increment32(this.counter);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        try {
            if (n2 < 0) {
                throw new IllegalBlockSizeException("Negative input size!");
            }
            if (n2 > 0) {
                int n4 = n2 % 16;
                int n5 = n2 - n4;
                this.update(byArray, n, n5, byArray2, n3);
                if (n4 != 0) {
                    byte[] byArray3 = new byte[16];
                    this.aes.encryptBlock(this.counter, 0, byArray3, 0);
                    for (int i = 0; i < n4; ++i) {
                        byArray2[n3 + n5 + i] = (byte)(byArray[n + n5 + i] ^ byArray3[i]);
                    }
                }
            }
        }
        finally {
            this.reset();
        }
        return n2;
    }

    void reset() {
        System.arraycopy(this.icb, 0, this.counter, 0, this.icb.length);
        this.counterSave = null;
    }

    void save() {
        this.counterSave = (byte[])this.counter.clone();
    }

    void restore() {
        if (this.counterSave != null) {
            this.counter = this.counterSave;
        }
    }
}

