/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class APIVersion {
    public static String getVersion() {
        String version = APIVersion.getConfigEntry("jboss-galleon-version");
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getConfigEntry(String entry) {
        String string;
        String prop = System.getProperty(entry);
        if (prop != null) {
            return prop;
        }
        InputStream stream = APIVersion.class.getResourceAsStream("galleon.properties");
        if (stream == null) {
            return null;
        }
        try {
            String value;
            Properties properties = new Properties();
            properties.load(stream);
            string = value = properties.getProperty(entry);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        stream.close();
        return string;
    }

    public static boolean isSupportedVersion(String inFeaturePack) {
        return APIVersion.getVersion().compareTo(inFeaturePack) >= 0;
    }

    public static String checkForLatestVersionURL() {
        JsonNode newer = APIVersion.getNewerRelease();
        if (newer != null) {
            return newer.get("html_url").asText();
        }
        return null;
    }

    public static String checkForLatestVersion() {
        JsonNode newer = APIVersion.getNewerRelease();
        if (newer != null) {
            return newer.get("tag_name").asText();
        }
        return null;
    }

    private static JsonNode getNewerRelease() {
        try {
            String value;
            ObjectMapper mapper = new ObjectMapper();
            JsonNode latest = mapper.readTree(new URL("https://api.github.com/repos/wildfly/galleon/releases/latest"));
            JsonNode tag = latest.get("tag_name");
            if (tag != null && (value = tag.asText()).compareTo(APIVersion.getVersion()) > 0) {
                return latest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

