/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.video;

import com.fluendo.player.Cortado;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.common.resources.Video;

public class VideoComponent
extends JPanel {
    private static final Logger logger = Logger.getLogger(VideoComponent.class.getName());
    private final Cortado applet;

    public VideoComponent(Video video, boolean mute, Dimension maximumSize) {
        String url = video.getURL().toExternalForm();
        this.setOpaque(false);
        this.setBorder(this.createBorder());
        Insets insets = this.getInsets();
        this.applet = new Cortado();
        this.applet.setSize(this.determineAppletSize(maximumSize));
        this.applet.setLocation(insets.left - 1, insets.top - 1);
        this.applet.setParam("url", url);
        this.applet.setParam("framerate", "60");
        this.applet.setParam("keepaspect", "true");
        this.applet.setParam("video", "true");
        this.applet.setParam("audio", mute ? "false" : "true");
        this.applet.setParam("kateIndex", "0");
        this.applet.setParam("bufferSize", "200");
        this.applet.setParam("showStatus", "hide");
        this.applet.setParam("debug", "0");
        this.applet.init();
        this.setLayout(null);
        this.add((Component)this.applet);
        this.setSize(this.applet.getWidth() + insets.left + insets.right - 2, this.applet.getHeight() + insets.top + insets.bottom - 2);
    }

    private Dimension determineAppletSize(Dimension maximumSize) {
        int x = 655;
        int y = 480;
        while (x * 2 < maximumSize.width && y * 2 < maximumSize.height) {
            x *= 2;
            y *= 2;
        }
        Dimension appletSize = new Dimension(x, y);
        return appletSize;
    }

    private Border createBorder() {
        return FreeColImageBorder.panelWithoutShadowBorder;
    }

    @Override
    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.applet.addMouseListener(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.applet.removeMouseListener(l);
    }

    public void play() {
        this.applet.start();
    }

    public void stop() {
        this.applet.stop();
    }

    @Override
    public void removeNotify() {
        this.applet.stop();
        this.applet.destroy();
        try {
            super.removeNotify();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Video removal crash", e);
        }
    }
}

