/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.DefaultClassFinder;
import org.eclipse.sisu.space.SpaceVisitor;
import org.eclipse.sisu.space.Streams;
import org.eclipse.sisu.space.asm.AnnotationVisitor;
import org.eclipse.sisu.space.asm.ClassReader;
import org.eclipse.sisu.space.asm.Type;

public final class SpaceScanner {
    private static final int ASM_FLAGS = 7;
    static final ClassFinder DEFAULT_FINDER = new DefaultClassFinder();
    private final ClassSpace space;
    private final ClassFinder finder;

    public SpaceScanner(ClassSpace space2, ClassFinder finder) {
        this.space = space2;
        this.finder = finder;
    }

    public SpaceScanner(ClassSpace space2) {
        this(space2, DEFAULT_FINDER);
    }

    public void accept(SpaceVisitor visitor) {
        visitor.enterSpace(this.space);
        Enumeration<URL> result = this.finder.findClasses(this.space);
        while (result.hasMoreElements()) {
            URL url = result.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (cv == null) continue;
            SpaceScanner.accept(cv, url);
        }
        visitor.leaveSpace();
    }

    public static void accept(ClassVisitor visitor, URL url) {
        if (url == null) {
            return;
        }
        try {
            InputStream in = Streams.open(url);
            try {
                new ClassReader(in).accept(SpaceScanner.adapt(visitor), 7);
            }
            finally {
                in.close();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e2) {
            Logs.trace("Problem scanning: {}", url, e2);
        }
    }

    public static String jvmDescriptor(Class<? extends Annotation> clazz) {
        return String.valueOf('L') + clazz.getName().replace('.', '/') + ';';
    }

    private static org.eclipse.sisu.space.asm.ClassVisitor adapt(final ClassVisitor _cv) {
        return _cv == null ? null : new org.eclipse.sisu.space.asm.ClassVisitor(327680){

            @Override
            public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces) {
                _cv.enterClass(access, name2, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final org.eclipse.sisu.space.AnnotationVisitor _av = _cv.visitAnnotation(desc);
                return _av == null ? null : new AnnotationVisitor(327680){
                    {
                        super($anonymous0);
                        annotationVisitor.enterAnnotation();
                    }

                    @Override
                    public void visit(String name2, Object value) {
                        _av.visitElement(name2, value instanceof Type ? ((Type)value).getClassName() : value);
                    }

                    @Override
                    public void visitEnd() {
                        _av.leaveAnnotation();
                    }
                };
            }

            @Override
            public void visitEnd() {
                _cv.leaveClass();
            }
        };
    }
}

