/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.custompages;

import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.custompages.CustomPageMatcherLocation;
import org.zaproxy.zap.utils.EnableableInterface;

public interface CustomPage
extends EnableableInterface {
    public int getContextId();

    public void setContextId(int var1);

    public String getPageMatcher();

    public void setPageMatcher(String var1);

    public CustomPageMatcherLocation getPageMatcherLocation();

    public void setPageMatcherLocation(CustomPageMatcherLocation var1);

    public boolean isRegex();

    public void setRegex(boolean var1);

    public Type getType();

    public void setType(Type var1);

    public boolean isCustomPage(HttpMessage var1, Type var2);

    public static enum Type {
        ERROR_500(1, "custompages.type.error"),
        NOTFOUND_404(2, "custompages.type.notfound"),
        OK_200(3, "custompages.type.ok"),
        OTHER(4, "custompages.type.other");

        private final int id;
        private final String name;
        private final String nameKey;

        private Type(int id, String nameKey) {
            this.id = id;
            this.name = Constant.messages.getString(nameKey);
            this.nameKey = nameKey;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        String getNameKey() {
            return this.nameKey;
        }

        public static Type getCustomPageTypeWithId(int id) {
            for (Type customPageType : Type.values()) {
                if (customPageType.id != id) continue;
                return customPageType;
            }
            return Type.getDefaultType();
        }

        protected static Type getDefaultType() {
            return ERROR_500;
        }

        public static String describeCustomPageTypes() {
            StringBuilder descCustomPageTypes = new StringBuilder();
            descCustomPageTypes.append("Available Custom Page Types (ID : Name): \n");
            for (Type cpt : Type.values()) {
                descCustomPageTypes.append(cpt.getId()).append(" : ").append(cpt.getName());
                descCustomPageTypes.append("\n");
            }
            return descCustomPageTypes.toString();
        }

        public String toString() {
            if (this.getName() == null) {
                return this.name();
            }
            return this.getName();
        }
    }
}

