/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.cpu;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ThreadsCPUInfo {
    private List<ThreadInfo> threads = new ArrayList<ThreadInfo>();
    private List<Long> cputime = new ArrayList<Long>();
    private Map<Long, Long> cputimeMap = new HashMap<Long, Long>(this.threads.size() * 4 / 3);
    private long totalCPUTime = 0L;
    private long timestamp;
    private long totalDiffCPUTime;

    ThreadsCPUInfo(long time, ThreadInfo[] tinfo, long[] cpuinfo) {
        for (int i = 0; i < tinfo.length; ++i) {
            ThreadInfo ti = tinfo[i];
            if (ti == null) continue;
            this.threads.add(ti);
            this.cputime.add(cpuinfo[i]);
            this.cputimeMap.put(ti.getThreadId(), cpuinfo[i]);
            this.totalCPUTime += cpuinfo[i];
        }
        this.timestamp = time;
    }

    List<ThreadInfo> getThreads() {
        return this.threads;
    }

    List<Long> getThreadCPUTime() {
        return this.cputime;
    }

    long getTotalCPUTime() {
        return this.totalCPUTime;
    }

    List<Long> getThreadCPUTimeDiff(ThreadsCPUInfo info) {
        ArrayList<Long> cpuTimeDiff = new ArrayList<Long>(this.threads.size());
        List<ThreadInfo> newThreads = info.getThreads();
        List<Long> newCPUTime = info.getThreadCPUTime();
        this.totalDiffCPUTime = 0L;
        for (int i = 0; i < newThreads.size(); ++i) {
            ThreadInfo ti = newThreads.get(i);
            Long oldAlloc = this.cputimeMap.get(ti.getThreadId());
            if (oldAlloc == null) {
                oldAlloc = 0L;
            }
            long diff = newCPUTime.get(i) - oldAlloc;
            cpuTimeDiff.add(diff);
            this.totalDiffCPUTime += diff;
        }
        return cpuTimeDiff;
    }

    long getTotalDiffCPUTime() {
        return this.totalDiffCPUTime;
    }

    List<Long> getCPUTimePerSecond(ThreadsCPUInfo newInfo) {
        assert (newInfo.timestamp >= this.timestamp);
        List<Long> diff = this.getThreadCPUTimeDiff(newInfo);
        double secs = (double)(newInfo.timestamp - this.timestamp) / 1000.0;
        ArrayList<Long> diffPerSec = new ArrayList<Long>(diff.size());
        for (Long d : diff) {
            diffPerSec.add(new Long((long)((double)d.longValue() / secs)));
        }
        return diffPerSec;
    }
}

