/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.classfile;

import java.io.IOException;
import java.util.ArrayList;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassFileParser;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassPath;

public class DynamicClassInfo
extends ClassInfo {
    private ArrayList subclasses;
    private DynamicClassInfo superClass;
    private String classFileLocation;
    private int[] baseCPoolCount;
    private int java_lang_ThowableCPIndex;
    private char[] instrMethodIds;
    private DynamicClassInfo[] interfacesDCI;
    private char[] methodScanStatus;
    private byte[][] modifiedAndSavedMethodInfos;
    private int[] modifiedMethodBytecodesLength;
    private int[] modifiledLocalVariableTableOffsets;
    private int[] modifiledLocalVariableTypeTableOffsets;
    private int[] modifiledStackMapTableOffsets;
    private boolean allMethodsMarkers = false;
    private boolean allMethodsRoots = false;
    private boolean hasUninstrumentedMarkerMethods;
    private boolean hasUninstrumentedRootMethods;
    private boolean hasMethodReachable;
    private boolean isLoaded;
    private boolean servletDoMethodScanned;
    private int currentCPoolCount;
    private int nInstrumentedMethods;
    ClassPath classPath;

    public DynamicClassInfo(ClassPath cp, String className, int loaderId, String classFileLocation) throws IOException, ClassFormatError {
        this(cp, className, loaderId, classFileLocation, true);
    }

    DynamicClassInfo(ClassPath cp, String className, int loaderId, String classFileLocation, boolean parseClass) throws IOException, ClassFormatError {
        super(className, loaderId);
        this.classFileLocation = classFileLocation;
        this.classPath = cp;
        if (parseClass) {
            this.parseClassFile(className);
        }
    }

    public void setAllMethodsMarkers() {
        this.allMethodsMarkers = true;
        this.hasUninstrumentedMarkerMethods = true;
    }

    public boolean getAllMethodsMarkers() {
        return this.allMethodsMarkers;
    }

    public void setAllMethodsRoots() {
        this.allMethodsRoots = true;
        this.hasUninstrumentedRootMethods = true;
    }

    public boolean getAllMethodsRoots() {
        return this.allMethodsRoots;
    }

    public void setBaseCPoolCount(int injType, int v) {
        this.baseCPoolCount[injType] = v;
    }

    public int getBaseCPoolCount(int injType) {
        return this.baseCPoolCount[injType];
    }

    public int getBaseCPoolCountLen() {
        return this.baseCPoolCount.length;
    }

    @Override
    public byte[] getClassFileBytes() throws IOException {
        return this.classPath.getClassFile(this.name, this.classFileLocation);
    }

    public String getClassFileLocation() {
        return this.classFileLocation;
    }

    public void setCurrentCPoolCount(int v) {
        this.currentCPoolCount = v;
    }

    public int getCurrentCPoolCount() {
        return this.currentCPoolCount;
    }

    @Override
    public int getExceptionTableStartOffsetInMethodInfo(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            int bcLen = this.getBCLenForModifiedAndSavedMethodInfo(idx);
            return this.methodBytecodesOffsets[idx] + bcLen;
        }
        return super.getExceptionTableStartOffsetInMethodInfo(idx);
    }

    @Override
    public int getLocalVariableTableStartOffsetInMethodInfo(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            if (this.modifiledLocalVariableTableOffsets[idx] == 0) {
                int newOffset = this.getExceptionTableStartOffsetInMethodInfo(idx) + this.getExceptionTableCount(idx) * 8 + 2;
                byte[] methodInfo = this.getMethodInfo(idx);
                int attrCount = DynamicClassInfo.getU2(methodInfo, newOffset);
                newOffset += 2;
                for (int k = 0; k < attrCount; ++k) {
                    int attrNameIdx = DynamicClassInfo.getU2(methodInfo, newOffset);
                    int attrLen = DynamicClassInfo.getU4(methodInfo, newOffset += 2);
                    newOffset += 4;
                    if (attrNameIdx == this.localVaribaleTableCPindex) {
                        this.modifiledLocalVariableTableOffsets[idx] = newOffset + 2;
                        break;
                    }
                    newOffset += attrLen;
                }
            }
            return this.modifiledLocalVariableTableOffsets[idx];
        }
        return super.getLocalVariableTableStartOffsetInMethodInfo(idx);
    }

    @Override
    public int getLocalVariableTypeTableStartOffsetInMethodInfo(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            if (this.modifiledLocalVariableTypeTableOffsets[idx] == 0) {
                int newOffset = this.getExceptionTableStartOffsetInMethodInfo(idx) + this.getExceptionTableCount(idx) * 8 + 2;
                byte[] methodInfo = this.getMethodInfo(idx);
                int attrCount = DynamicClassInfo.getU2(methodInfo, newOffset);
                newOffset += 2;
                for (int k = 0; k < attrCount; ++k) {
                    int attrNameIdx = DynamicClassInfo.getU2(methodInfo, newOffset);
                    int attrLen = DynamicClassInfo.getU4(methodInfo, newOffset += 2);
                    newOffset += 4;
                    if (attrNameIdx == this.localVaribaleTypeTableCPindex) {
                        this.modifiledLocalVariableTypeTableOffsets[idx] = newOffset + 2;
                        break;
                    }
                    newOffset += attrLen;
                }
            }
            return this.modifiledLocalVariableTypeTableOffsets[idx];
        }
        return super.getLocalVariableTypeTableStartOffsetInMethodInfo(idx);
    }

    @Override
    public int getStackMapTableStartOffsetInMethodInfo(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            if (this.modifiledStackMapTableOffsets[idx] == 0) {
                int newOffset = this.getExceptionTableStartOffsetInMethodInfo(idx) + this.getExceptionTableCount(idx) * 8 + 2;
                byte[] methodInfo = this.getMethodInfo(idx);
                int attrCount = DynamicClassInfo.getU2(methodInfo, newOffset);
                newOffset += 2;
                for (int k = 0; k < attrCount; ++k) {
                    int attrNameIdx = DynamicClassInfo.getU2(methodInfo, newOffset);
                    int attrLen = DynamicClassInfo.getU4(methodInfo, newOffset += 2);
                    newOffset += 4;
                    if (attrNameIdx == this.stackMapTableCPindex) {
                        this.modifiledStackMapTableOffsets[idx] = newOffset + 2;
                        break;
                    }
                    newOffset += attrLen;
                }
            }
            return this.modifiledStackMapTableOffsets[idx];
        }
        return super.getStackMapTableStartOffsetInMethodInfo(idx);
    }

    public void setHasUninstrumentedMarkerMethods(boolean v) {
        this.hasUninstrumentedMarkerMethods = v;
    }

    public void setHasUninstrumentedRootMethods(boolean v) {
        this.hasUninstrumentedRootMethods = v;
    }

    public void setInstrMethodId(int i, int id) {
        this.instrMethodIds[i] = (char)id;
    }

    public char getInstrMethodId(int i) {
        return this.instrMethodIds[i];
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public byte[] getMethodBytecode(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            byte[] methodInfo = this.modifiedAndSavedMethodInfos[idx];
            int bcLen = this.getBCLenForModifiedAndSavedMethodInfo(idx);
            byte[] ret = new byte[bcLen];
            System.arraycopy(methodInfo, this.methodBytecodesOffsets[idx], ret, 0, bcLen);
            return ret;
        }
        return super.getMethodBytecode(idx);
    }

    @Override
    public int getMethodBytecodesLength(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            return this.getBCLenForModifiedAndSavedMethodInfo(idx);
        }
        return super.getMethodBytecodesLength(idx);
    }

    @Override
    public byte[] getMethodInfo(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            return this.modifiedAndSavedMethodInfos[idx];
        }
        return super.getMethodInfo(idx);
    }

    @Override
    public int getMethodInfoLength(int idx) {
        if (this.modifiedAndSavedMethodInfos != null && this.modifiedAndSavedMethodInfos[idx] != null) {
            return this.modifiedAndSavedMethodInfos[idx].length;
        }
        return super.getMethodInfoLength(idx);
    }

    public void setMethodInstrumented(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 8);
        ++this.nInstrumentedMethods;
    }

    public boolean isMethodInstrumented(int i) {
        return (this.methodScanStatus[i] & 8) != 0;
    }

    public void setMethodLeaf(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x10);
    }

    public boolean isMethodLeaf(int i) {
        return (this.methodScanStatus[i] & 0x10) != 0;
    }

    public void setMethodMarker(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x100);
        this.hasUninstrumentedMarkerMethods = true;
    }

    public boolean isMethodMarker(int i) {
        return this.allMethodsMarkers || (this.methodScanStatus[i] & 0x100) != 0;
    }

    public boolean hasMethodReachable() {
        return this.hasMethodReachable;
    }

    public void setMethodReachable(int i) {
        this.hasMethodReachable = true;
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | '\u0001');
    }

    public boolean isMethodReachable(int i) {
        return (this.methodScanStatus[i] & '\u0001') != 0;
    }

    public void setMethodRoot(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x40);
        this.hasUninstrumentedRootMethods = true;
    }

    public boolean isMethodRoot(int i) {
        return this.allMethodsRoots || (this.methodScanStatus[i] & 0x40) != 0;
    }

    public void setMethodScanned(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 4);
    }

    public boolean isMethodScanned(int i) {
        return (this.methodScanStatus[i] & 4) != 0;
    }

    public void setMethodSpecial(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x80);
    }

    public boolean isMethodSpecial(int i) {
        return (this.methodScanStatus[i] & 0x80) != 0;
    }

    public void setMethodUnscannable(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 2);
    }

    public boolean isMethodUnscannable(int i) {
        return (this.methodScanStatus[i] & 2) != 0;
    }

    public void setMethodVirtual(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] | 0x20);
    }

    public boolean isMethodVirtual(int i) {
        return (this.methodScanStatus[i] & 0x20) != 0;
    }

    public byte[] getOrigMethodInfo(int idx) {
        return super.getMethodInfo(idx);
    }

    public int getOrigMethodInfoLength(int idx) {
        return super.getMethodInfoLength(idx);
    }

    public void setServletDoMethodScanned() {
        this.servletDoMethodScanned = true;
    }

    public boolean isServletDoMethodScanned() {
        return this.servletDoMethodScanned;
    }

    public boolean isSubclassOf(String superClass) {
        if (this.getName() == superClass) {
            return true;
        }
        DynamicClassInfo sc = this.getSuperClass();
        if (sc == null || sc == this) {
            return false;
        }
        return sc.isSubclassOf(superClass);
    }

    public ArrayList getSubclasses() {
        return this.subclasses;
    }

    public void setSuperClass(DynamicClassInfo sc) {
        this.superClass = sc;
    }

    public DynamicClassInfo getSuperClass() {
        return this.superClass;
    }

    public void setSuperInterface(DynamicClassInfo si, int idx) {
        if (this.interfacesDCI == null) {
            this.interfacesDCI = new DynamicClassInfo[this.interfaces.length];
        }
        this.interfacesDCI[idx] = si;
    }

    public DynamicClassInfo[] getSuperInterfaces() {
        return this.interfacesDCI;
    }

    public void addSubclass(DynamicClassInfo subclass) {
        if (this.subclasses == null) {
            this.subclasses = this.name == "java/lang/Object" ? new ArrayList(500) : new ArrayList();
        }
        if (this.isInterface() && this.subclasses.contains(subclass)) {
            return;
        }
        this.subclasses.add(subclass);
    }

    public void preloadBytecode() {
    }

    public void setInterface() {
    }

    public boolean hasInstrumentedMethods() {
        return this.nInstrumentedMethods > 0;
    }

    public boolean hasUninstrumentedMarkerMethods() {
        return this.hasUninstrumentedMarkerMethods;
    }

    public boolean hasUninstrumentedRootMethods() {
        return this.hasUninstrumentedRootMethods;
    }

    public boolean implementsInterface(String intfName) {
        DynamicClassInfo superClass;
        String[] intfs = this.getInterfaceNames();
        if (intfs != null) {
            for (String intf : intfs) {
                if (intfName != intf) continue;
                return true;
            }
            DynamicClassInfo[] intfsDCI = this.getSuperInterfaces();
            if (intfsDCI != null) {
                for (DynamicClassInfo intfClazz : intfsDCI) {
                    if (intfClazz == null || !intfClazz.implementsInterface(intfName)) continue;
                    return true;
                }
            }
        }
        if ((superClass = this.getSuperClass()) == null || superClass.getName() == "java/lang/Object") {
            return false;
        }
        return superClass.implementsInterface(intfName);
    }

    public void saveMethodInfo(int idx, byte[] methodInfo) {
        if (this.modifiedAndSavedMethodInfos == null) {
            this.modifiedAndSavedMethodInfos = new byte[this.methodNames.length][];
        }
        this.modifiedAndSavedMethodInfos[idx] = methodInfo;
        this.modifiedMethodBytecodesLength = new int[this.methodNames.length];
        this.modifiledLocalVariableTableOffsets = new int[this.methodNames.length];
        this.modifiledLocalVariableTypeTableOffsets = new int[this.methodNames.length];
        this.modifiledStackMapTableOffsets = new int[this.methodNames.length];
    }

    public void unsetMethodInstrumented(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] & 0xFFFFFFF7);
        --this.nInstrumentedMethods;
    }

    public void unsetMethodSpecial(int i) {
        int n = i;
        this.methodScanStatus[n] = (char)(this.methodScanStatus[n] & 0xFFFFFF7F);
    }

    @Override
    public void resetTables() {
        if (this.modifiedAndSavedMethodInfos == null) {
            super.resetTables();
        }
    }

    public void addGlobalCatchStackMapTableEntry(int methodIdx, int endPC) {
        if (this.majorVersion >= 50) {
            boolean isStatic = this.isMethodStatic(methodIdx);
            boolean constructor = "<init>".equals(this.getMethodName(methodIdx));
            int[] localsCPIdx = new int[]{};
            if (this.stackMapTableCPindex == 0) {
                this.stackMapTableCPindex = this.getBaseCPoolCount(11);
            }
            if (this.java_lang_ThowableCPIndex == 0) {
                this.java_lang_ThowableCPIndex = this.getCPIndexOfClass("java/lang/Throwable");
                if (this.java_lang_ThowableCPIndex == -1) {
                    this.java_lang_ThowableCPIndex = this.getBaseCPoolCount(12);
                }
            }
            int[] stacksCPIdx = new int[]{this.java_lang_ThowableCPIndex};
            if (!isStatic) {
                localsCPIdx = constructor ? new int[]{0} : new int[]{this.classIndex};
            }
            this.getStackMapTables().addFullStackMapFrameEntry(methodIdx, endPC, localsCPIdx, stacksCPIdx);
        }
    }

    final void parseClassFile(String className) throws ClassFormatError, IOException {
        byte[] classFileBytes = this.getClassFileBytes();
        try {
            new ClassFileParser().parseClassFile(classFileBytes, this);
            if (!className.equals(this.name)) {
                throw new ClassFormatError("Mismatch between name in .class file and location for " + className + "\nYour class path setting may be incorrect.");
            }
        }
        catch (ClassFileParser.ClassFileReadException ex) {
            throw new ClassFormatError(ex.getMessage());
        }
        this.methodScanStatus = new char[this.methodNames.length];
        this.instrMethodIds = new char[this.methodNames.length];
        this.currentCPoolCount = this.origCPoolCount;
        this.baseCPoolCount = new int[13];
        for (int i = 0; i < 13; ++i) {
            this.baseCPoolCount[i] = -1;
        }
    }

    private int getBCLenForModifiedAndSavedMethodInfo(int idx) {
        if (this.modifiedMethodBytecodesLength[idx] == 0) {
            byte[] methodInfo = this.modifiedAndSavedMethodInfos[idx];
            int bcLenPos = this.methodBytecodesOffsets[idx] - 4;
            this.modifiedMethodBytecodesLength[idx] = DynamicClassInfo.getU4(methodInfo, bcLenPos);
        }
        return this.modifiedMethodBytecodesLength[idx];
    }

    static int getU2(byte[] bytecodes, int pos) {
        return ((bytecodes[pos] & 0xFF) << 8) + (bytecodes[pos + 1] & 0xFF);
    }

    static int getU4(byte[] bytecodes, int pos) {
        return ((bytecodes[pos] & 0xFF) << 24) + ((bytecodes[pos + 1] & 0xFF) << 16) + ((bytecodes[pos + 2] & 0xFF) << 8) + (bytecodes[pos + 3] & 0xFF);
    }
}

