/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Struct;
import io.grpc.CallOptions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.xds.ClusterImplLoadBalancer;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.client.Bootstrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

@Internal
public final class ClusterImplLoadBalancerProvider
extends LoadBalancerProvider {
    public static final CallOptions.Key<Consumer<Map<String, Struct>>> FILTER_METADATA_CONSUMER = CallOptions.Key.createWithDefault((String)"io.grpc.xds.internalFilterMetadataConsumer", m -> {});

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "cluster_impl_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription(this.getPolicyName() + " cannot be used from service config"));
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterImplLoadBalancer(helper);
    }

    static final class ClusterImplConfig {
        final String cluster;
        @Nullable
        final String edsServiceName;
        @Nullable
        final Bootstrapper.ServerInfo lrsServerInfo;
        @Nullable
        final Long maxConcurrentRequests;
        @Nullable
        final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
        final List<Endpoints.DropOverload> dropCategories;
        final Object childConfig;
        final Map<String, Struct> filterMetadata;

        ClusterImplConfig(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, List<Endpoints.DropOverload> dropCategories, Object childConfig, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, Map<String, Struct> filterMetadata) {
            this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
            this.edsServiceName = edsServiceName;
            this.lrsServerInfo = lrsServerInfo;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.tlsContext = tlsContext;
            this.filterMetadata = ImmutableMap.copyOf(filterMetadata);
            this.dropCategories = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(dropCategories, (Object)"dropCategories")));
            this.childConfig = Preconditions.checkNotNull((Object)childConfig, (Object)"childConfig");
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerInfo", (Object)this.lrsServerInfo).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests).add("dropCategories", this.dropCategories).add("childConfig", this.childConfig).toString();
        }
    }
}

