/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogListener;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger;
import com.intellij.internal.statistic.service.fus.collectors.ProjectFUStateUsagesLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u0006\u0010\t\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/FusStatesRecorder;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "state", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "isRecordingInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "recordStateAndWait", "", "project", "Lcom/intellij/openapi/project/Project;", "recorderId", "", "recordEvent", "", "logEvent", "getCurrentState", "", "isComparisonAvailable", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nFusStatesRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FusStatesRecorder.kt\ncom/intellij/internal/statistic/devkit/actions/FusStatesRecorder\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n40#2,3:76\n40#2,3:81\n31#3,2:79\n14#4:84\n*S KotlinDebug\n*F\n+ 1 FusStatesRecorder.kt\ncom/intellij/internal/statistic/devkit/actions/FusStatesRecorder\n*L\n34#1:76,3\n55#1:81,3\n36#1:79,2\n20#1:84\n*E\n"})
public final class FusStatesRecorder {
    @NotNull
    public static final FusStatesRecorder INSTANCE = new FusStatesRecorder();
    @NotNull
    private static final Logger log;
    @NotNull
    private static final ConcurrentLinkedQueue<LogEvent> state;
    @NotNull
    private static AtomicBoolean isRecordingInProgress;
    @NotNull
    private static final Object lock;

    private FusStatesRecorder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<LogEvent> recordStateAndWait(@NotNull Project project, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Object object = lock;
        synchronized (object) {
            Class<ProjectFUStateUsagesLogger> serviceClass$iv;
            boolean bl = false;
            state.clear();
            isRecordingInProgress.getAndSet(true);
            StatisticsEventLogListener subscriber2 = new StatisticsEventLogListener(){

                public void onLogEvent(LogEvent validatedEvent, String rawEventId, Map<String, ? extends Object> rawData) {
                    Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
                    FusStatesRecorder.access$recordEvent(FusStatesRecorder.INSTANCE, validatedEvent);
                }
            };
            boolean $i$f$service = false;
            Class<EventLogListenersManager> serviceClass$iv2 = EventLogListenersManager.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((EventLogListenersManager)object2).subscribe(subscriber2, recorderId);
            try {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service2 = false;
                serviceClass$iv = ProjectFUStateUsagesLogger.class;
                Object object3 = $this$service$iv.getService(serviceClass$iv);
                if (object3 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Void cfr_ignored_0 = (Void)((CompletableFuture)FutureKt.asCompletableFuture((Job)((ProjectFUStateUsagesLogger)object3).scheduleLogApplicationAndProjectState()).thenCompose(arg_0 -> FusStatesRecorder.recordStateAndWait$lambda$2$lambda$1(arg_0 -> FusStatesRecorder.recordStateAndWait$lambda$2$lambda$0(recorderId, arg_0), arg_0))).get(30L, TimeUnit.SECONDS);
                $i$f$service2 = false;
                serviceClass$iv = EventLogListenersManager.class;
            }
            catch (Exception e) {
                Class<EventLogListenersManager> serviceClass$iv3;
                List<LogEvent> serviceClass$iv4;
                try {
                    log.warn("Failed recording state collectors to log", (Throwable)e);
                    serviceClass$iv4 = null;
                    boolean $i$f$service3 = false;
                    serviceClass$iv3 = EventLogListenersManager.class;
                }
                catch (Throwable throwable) {
                    boolean $i$f$service4 = false;
                    Class<EventLogListenersManager> serviceClass$iv5 = EventLogListenersManager.class;
                    Object object4 = ApplicationManager.getApplication().getService(serviceClass$iv5);
                    if (object4 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv5.getName() + " (classloader=" + serviceClass$iv5.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    ((EventLogListenersManager)object4).unsubscribe(subscriber2, recorderId);
                    isRecordingInProgress.getAndSet(false);
                    throw throwable;
                }
                Object object5 = ApplicationManager.getApplication().getService(serviceClass$iv3);
                if (object5 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv3.getName() + " (classloader=" + serviceClass$iv3.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((EventLogListenersManager)object5).unsubscribe(subscriber2, recorderId);
                isRecordingInProgress.getAndSet(false);
                return serviceClass$iv4;
            }
            Object object6 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object6 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((EventLogListenersManager)object6).unsubscribe(subscriber2, recorderId);
            isRecordingInProgress.getAndSet(false);
            return CollectionsKt.toList((Iterable)state);
        }
    }

    private final void recordEvent(LogEvent logEvent) {
        if (logEvent.getEvent().getState()) {
            state.add(logEvent);
        }
    }

    @NotNull
    public final List<LogEvent> getCurrentState() {
        return CollectionsKt.toList((Iterable)state);
    }

    public final boolean isRecordingInProgress() {
        return isRecordingInProgress.get();
    }

    public final boolean isComparisonAvailable() {
        return !isRecordingInProgress.get() && !((Collection)state).isEmpty();
    }

    private static final CompletionStage recordStateAndWait$lambda$2$lambda$0(String $recorderId, Unit it) {
        StatisticsEventLogger logger = StatisticsEventLogProviderUtil.getEventLogProvider((String)$recorderId).getLogger();
        return logger instanceof StatisticsFileEventLogger ? ((StatisticsFileEventLogger)logger).flush() : CompletableFuture.completedFuture(null);
    }

    private static final CompletionStage recordStateAndWait$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$recordEvent(FusStatesRecorder $this, LogEvent logEvent) {
        $this.recordEvent(logEvent);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FusStatesRecorder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        state = new ConcurrentLinkedQueue();
        isRecordingInProgress = new AtomicBoolean(false);
        lock = new Object();
    }
}

