/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a4\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0014H\u0002\u001a4\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0014H\u0002\u00a8\u0006\u0016"}, d2={"transferRootsToModulesWithSdk", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "removeTransferredRootsFromModulesWithSdk", "transferRootsToModulesWithInheritedSdk", "removeTransferredRootsFromModulesWithInheritedSdk", "getPathsToTransfer", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "setPathsToTransfer", "roots", "transferRoots", "module", "Lcom/intellij/openapi/module/Module;", "removeTransferredRoots", "updateRootsForModulesWithSdk", "action", "Lkotlin/Function2;", "updateRootsForModulesWithInheritedSdk", "intellij.python.community.impl"})
public final class PyTransferredSdkRootsKt {
    public static final void transferRootsToModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithSdk.1.INSTANCE));
    }

    public static final void transferRootsToModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithInheritedSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithInheritedSdk.1.INSTANCE));
    }

    @NotNull
    public static final Set<VirtualFile> getPathsToTransfer(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        Object object = sdkAdditionalData instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdkAdditionalData : null;
        if (object == null || (object = ((PythonSdkAdditionalData)object).getPathsToTransfer()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    public static final void setPathsToTransfer(@NotNull Sdk sdk2, @NotNull Set<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        ActionsKt.runInEdt$default(null, () -> PyTransferredSdkRootsKt.setPathsToTransfer$lambda$2(roots, sdk2), (int)1, null);
    }

    public static final void transferRoots(@NotNull Module module, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk2 != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk2)) {
            ActionsKt.runInEdt$default(null, () -> PyTransferredSdkRootsKt.transferRoots$lambda$3(module, sdk2), (int)1, null);
        }
    }

    public static final void removeTransferredRoots(@NotNull Module module, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk2 != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk2)) {
            ActionsKt.runInEdt$default(null, () -> PyTransferredSdkRootsKt.removeTransferredRoots$lambda$4(module, sdk2), (int)1, null);
        }
    }

    private static final void updateRootsForModulesWithSdk(Project project, Sdk sdk2, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk2 == null) {
            return;
        }
        for (Module module : (Module[])ActionsKt.runReadAction(() -> PyTransferredSdkRootsKt.updateRootsForModulesWithSdk$lambda$5(project))) {
            action.invoke((Object)module, (Object)sdk2);
        }
    }

    private static final void updateRootsForModulesWithInheritedSdk(Project project, Sdk sdk2, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk2 == null) {
            return;
        }
        for (Module module : (Module[])ActionsKt.runReadAction(() -> PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk$lambda$6(project))) {
            if (!ModuleRootManager.getInstance((Module)module).isSdkInherited()) continue;
            action.invoke((Object)module, (Object)sdk2);
        }
    }

    private static final Unit setPathsToTransfer$lambda$2$lambda$1$lambda$0(SdkModificator $this_apply) {
        $this_apply.commitChanges();
        return Unit.INSTANCE;
    }

    private static final Unit setPathsToTransfer$lambda$2(Set $roots, Sdk $sdk) {
        if (!((Collection)$roots).isEmpty() || !((Collection)PyTransferredSdkRootsKt.getPathsToTransfer($sdk)).isEmpty()) {
            SdkModificator sdkModificator;
            PySdkExtKt.getOrCreateAdditionalData($sdk);
            SdkModificator $this$setPathsToTransfer_u24lambda_u242_u24lambda_u241 = sdkModificator = $sdk.getSdkModificator();
            boolean bl = false;
            SdkAdditionalData sdkAdditionalData = $this$setPathsToTransfer_u24lambda_u242_u24lambda_u241.getSdkAdditionalData();
            Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.sdk.PythonSdkAdditionalData");
            ((PythonSdkAdditionalData)sdkAdditionalData).setPathsToTransferFromVirtualFiles($roots);
            ActionsKt.runWriteAction(() -> PyTransferredSdkRootsKt.setPathsToTransfer$lambda$2$lambda$1$lambda$0($this$setPathsToTransfer_u24lambda_u242_u24lambda_u241));
        }
        return Unit.INSTANCE;
    }

    private static final Unit transferRoots$lambda$3(Module $module, Sdk $sdk) {
        PyUtil.addSourceRoots($module, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer($sdk));
        return Unit.INSTANCE;
    }

    private static final Unit removeTransferredRoots$lambda$4(Module $module, Sdk $sdk) {
        PyUtil.removeSourceRoots($module, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer($sdk));
        return Unit.INSTANCE;
    }

    private static final Module[] updateRootsForModulesWithSdk$lambda$5(Project $project) {
        return ModuleManager.Companion.getInstance($project).getModules();
    }

    private static final Module[] updateRootsForModulesWithInheritedSdk$lambda$6(Project $project) {
        return ModuleManager.Companion.getInstance($project).getModules();
    }
}

