/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.codeFragment;

import com.intellij.codeInsight.codeFragment.CannotCreateCodeFragmentException;
import com.intellij.codeInsight.codeFragment.CodeFragmentUtil;
import com.intellij.codeInsight.codeFragment.Position;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCodeFragmentUtil {
    private PyCodeFragmentUtil() {
    }

    @NotNull
    public static PyCodeFragment createCodeFragment(@NotNull ScopeOwner owner, @NotNull PsiElement startInScope, @NotNull PsiElement endInScope) throws CannotCreateCodeFragmentException {
        boolean bl;
        if (owner == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(0);
        }
        if (startInScope == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(1);
        }
        if (endInScope == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(2);
        }
        int start = startInScope.getTextOffset();
        int end = endInScope.getTextOffset() + endInScope.getTextLength();
        ControlFlow flow = ControlFlowCache.getControlFlow(owner);
        List<Instruction> graph = Arrays.asList(flow.getInstructions());
        List<Instruction> subGraph = PyCodeFragmentUtil.getFragmentSubGraph(graph, start, end);
        AnalysisResult subGraphAnalysis = PyCodeFragmentUtil.analyseSubGraph(subGraph, start, end);
        if (subGraphAnalysis.regularExits > 0 && subGraphAnalysis.returns > 0 || subGraphAnalysis.outerLoopBreaks > 0) {
            throw new CannotCreateCodeFragmentException(PyPsiBundle.message("refactoring.extract.method.error.interrupted.execution.flow", new Object[0]));
        }
        if (subGraphAnalysis.starImports > 0) {
            throw new CannotCreateCodeFragmentException(PyPsiBundle.message("refactoring.extract.method.error.star.import", new Object[0]));
        }
        Set<String> globalWrites = PyCodeFragmentUtil.getGlobalWrites(subGraph, owner);
        Set<String> nonlocalWrites = PyCodeFragmentUtil.getNonlocalWrites(subGraph, owner);
        HashSet<String> inputNames = new HashSet<String>();
        for (PsiElement psiElement : PyCodeFragmentUtil.filterElementsInScope(PyCodeFragmentUtil.getInputElements(subGraph, graph), owner)) {
            String name2 = PyCodeFragmentUtil.getName(psiElement);
            if (name2 == null || PyCodeFragmentUtil.resolvesToBoundMethodParameter(psiElement) || globalWrites.contains(name2) || nonlocalWrites.contains(name2)) continue;
            inputNames.add(name2);
        }
        HashSet<String> outputNames = new HashSet<String>();
        for (PsiElement element : PyCodeFragmentUtil.getOutputElements(subGraph, graph)) {
            String name3 = PyCodeFragmentUtil.getName(element);
            if (name3 == null || globalWrites.contains(name3) || nonlocalWrites.contains(name3)) continue;
            outputNames.add(name3);
        }
        boolean bl2 = bl = subGraphAnalysis.yieldExpressions > 0;
        if (bl && LanguageLevel.forElement((PsiElement)owner).isPython2()) {
            throw new CannotCreateCodeFragmentException(PyPsiBundle.message("refactoring.extract.method.error.yield", new Object[0]));
        }
        boolean isAsync = owner instanceof PyFunction && ((PyFunction)owner).isAsync();
        return new PyCodeFragment(inputNames, outputNames, globalWrites, nonlocalWrites, subGraphAnalysis.returns > 0, bl, isAsync);
    }

    private static boolean resolvesToBoundMethodParameter(@NotNull PsiElement element) {
        PyAstFunction.Modifier modifier;
        PyParameter[] parameters;
        PyParameterList parameterList;
        PsiElement resolved;
        PsiReference reference;
        PyFunction function;
        if (element == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(3);
        }
        return PyPsiUtils.isMethodContext(element) && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class)) != null && (reference = element.getReference()) != null && (resolved = reference.resolve()) instanceof PyParameter && (parameterList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PyParameterList.class)) != null && (parameters = parameterList.getParameters()).length > 0 && resolved == parameters[0] && ((modifier = function.getModifier()) == null || modifier == PyAstFunction.Modifier.CLASSMETHOD);
    }

    @Nullable
    private static String getName(@NotNull PsiElement element) {
        if (element == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        if (element instanceof PyImportElement) {
            return ((PyImportElement)element).getVisibleName();
        }
        if (element instanceof PyElement) {
            return ((PyElement)element).getName();
        }
        return null;
    }

    @NotNull
    private static List<Instruction> getFragmentSubGraph(@NotNull List<Instruction> graph, int start, int end) {
        if (graph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(5);
        }
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        for (Instruction instruction : graph) {
            PsiElement element = instruction.getElement();
            if (element == null || CodeFragmentUtil.getPosition((PsiElement)element, (int)start, (int)end) != Position.INSIDE) continue;
            instructions.add(instruction);
        }
        for (Instruction instruction : graph) {
            ReadWriteInstruction readWriteInstruction;
            if (!(instruction instanceof ReadWriteInstruction) || !(readWriteInstruction = (ReadWriteInstruction)instruction).getAccess().isAssertTypeAccess()) continue;
            boolean innerAssertType = true;
            for (Instruction next : readWriteInstruction.allSucc()) {
                if (instructions.contains(next)) continue;
                innerAssertType = false;
                break;
            }
            if (!innerAssertType || instructions.contains(instruction)) continue;
            instructions.add(instruction);
        }
        ArrayList<Instruction> arrayList = instructions;
        if (arrayList == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static AnalysisResult analyseSubGraph(@NotNull List<Instruction> subGraph, int start, int end) {
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(7);
        }
        int returnSources = 0;
        int regularSources = 0;
        int starImports = 0;
        int outerLoopBreaks = 0;
        int yieldExpressions = 0;
        for (Pair<Instruction, Instruction> edge : PyCodeFragmentUtil.getOutgoingEdges(subGraph)) {
            boolean isExceptTarget;
            Instruction sourceInstruction = (Instruction)edge.getFirst();
            Instruction targetInstruction = (Instruction)edge.getSecond();
            PsiElement source = sourceInstruction.getElement();
            PsiElement target = targetInstruction.getElement();
            PyReturnStatement returnStatement = (PyReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)source, PyReturnStatement.class, (boolean)false);
            boolean bl = isExceptTarget = target instanceof PyExceptPart || target instanceof PyFinallyPart;
            if (returnStatement != null && CodeFragmentUtil.getPosition((PsiElement)returnStatement, (int)start, (int)end) == Position.INSIDE) {
                ++returnSources;
                continue;
            }
            if (isExceptTarget) continue;
            ++regularSources;
        }
        Set<PsiElement> subGraphElements = PyCodeFragmentUtil.getSubGraphElements(subGraph);
        for (PsiElement element : subGraphElements) {
            PyLoopStatement loopStatement;
            PyFromImportStatement fromImportStatement;
            if (element instanceof PyFromImportStatement && (fromImportStatement = (PyFromImportStatement)element).getStarImportElement() != null) {
                ++starImports;
            }
            if ((element instanceof PyContinueStatement || element instanceof PyBreakStatement) && (loopStatement = PyUtil.getCorrespondingLoop(element)) != null && !subGraphElements.contains(loopStatement)) {
                ++outerLoopBreaks;
            }
            if (!(element instanceof PyYieldExpression)) continue;
            ++yieldExpressions;
        }
        return new AnalysisResult(starImports, returnSources, regularSources, outerLoopBreaks, yieldExpressions);
    }

    @NotNull
    private static Set<Pair<Instruction, Instruction>> getOutgoingEdges(@NotNull Collection<Instruction> subGraph) {
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(8);
        }
        HashSet<Pair<Instruction, Instruction>> outgoing = new HashSet<Pair<Instruction, Instruction>>();
        for (Instruction instruction : subGraph) {
            for (Instruction next : instruction.allSucc()) {
                if (subGraph.contains(next)) continue;
                outgoing.add((Pair<Instruction, Instruction>)Pair.create((Object)instruction, (Object)next));
            }
        }
        HashSet<Pair<Instruction, Instruction>> hashSet = outgoing;
        if (hashSet == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public static List<PsiElement> getInputElements(@NotNull List<Instruction> subGraph, @NotNull List<Instruction> graph) {
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(10);
        }
        if (graph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(11);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        Set<PsiElement> subGraphElements = PyCodeFragmentUtil.getSubGraphElements(subGraph);
        block0: for (Instruction instruction : PyCodeFragmentUtil.getReadInstructions(subGraph)) {
            PsiReference reference;
            PsiElement element = instruction.getElement();
            if (element == null || (reference = element.getReference()) == null) continue;
            for (PsiElement resolved : PyCodeFragmentUtil.multiResolve(reference)) {
                if (subGraphElements.contains(resolved)) continue;
                result2.add(element);
                continue block0;
            }
        }
        List<PsiElement> outputElements = PyCodeFragmentUtil.getOutputElements(subGraph, graph);
        for (Instruction instruction : PyCodeFragmentUtil.getWriteInstructions(subGraph)) {
            PsiReference reference;
            PsiElement element = instruction.getElement();
            if (element == null || (reference = element.getReference()) == null) continue;
            for (PsiElement resolved : PyCodeFragmentUtil.multiResolve(reference)) {
                if (subGraphElements.contains(resolved) || !outputElements.contains(element)) continue;
                result2.add(element);
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiElement> getOutputElements(@NotNull List<Instruction> subGraph, @NotNull List<Instruction> graph) {
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(13);
        }
        if (graph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(14);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        ArrayList<Instruction> outerGraph = new ArrayList<Instruction>();
        for (Instruction instruction : graph) {
            if (subGraph.contains(instruction)) continue;
            outerGraph.add(instruction);
        }
        Set<PsiElement> subGraphElements = PyCodeFragmentUtil.getSubGraphElements(subGraph);
        for (Instruction instruction : PyCodeFragmentUtil.getReadInstructions(outerGraph)) {
            PsiReference reference;
            PsiElement element = instruction.getElement();
            if (element == null || (reference = element.getReference()) == null) continue;
            for (PsiElement resolved : PyCodeFragmentUtil.multiResolve(reference)) {
                if (!subGraphElements.contains(resolved)) continue;
                result2.add(resolved);
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiElement> filterElementsInScope(@NotNull Collection<PsiElement> elements, @NotNull ScopeOwner owner) {
        if (elements == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(16);
        }
        if (owner == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(17);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            PsiElement resolved;
            PsiReference reference = element.getReference();
            if (reference == null || (resolved = reference.resolve()) == null || ScopeUtil.getScopeOwner(resolved) != owner || owner instanceof PsiFile) continue;
            result2.add(element);
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static Set<PsiElement> getSubGraphElements(@NotNull List<Instruction> subGraph) {
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(19);
        }
        HashSet<PsiElement> result2 = new HashSet<PsiElement>();
        for (Instruction instruction : subGraph) {
            PsiElement element = instruction.getElement();
            if (element == null) continue;
            result2.add(element);
        }
        HashSet<PsiElement> hashSet = result2;
        if (hashSet == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> getGlobalWrites(@NotNull List<Instruction> instructions, @NotNull ScopeOwner owner) {
        if (instructions == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(21);
        }
        if (owner == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(22);
        }
        Scope scope = ControlFlowCache.getScope(owner);
        LinkedHashSet<String> globalWrites = new LinkedHashSet<String>();
        for (Instruction instruction : PyCodeFragmentUtil.getWriteInstructions(instructions)) {
            if (!(instruction instanceof ReadWriteInstruction)) continue;
            String name2 = ((ReadWriteInstruction)instruction).getName();
            PsiElement element = instruction.getElement();
            if (!scope.isGlobal(name2) && (!(owner instanceof PsiFile) || !(element instanceof PsiNamedElement) || !PyCodeFragmentUtil.isUsedOutside((PsiNamedElement)element, instructions))) continue;
            globalWrites.add(name2);
        }
        LinkedHashSet<String> linkedHashSet = globalWrites;
        if (linkedHashSet == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(23);
        }
        return linkedHashSet;
    }

    private static boolean isUsedOutside(@NotNull PsiNamedElement element, @NotNull List<Instruction> subGraph) {
        if (element == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(24);
        }
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(25);
        }
        Set<PsiElement> subGraphElements = PyCodeFragmentUtil.getSubGraphElements(subGraph);
        return ContainerUtil.exists(PyPsiIndexUtil.findUsages(element, false), usageInfo -> !subGraphElements.contains(usageInfo.getElement()));
    }

    @NotNull
    private static Set<String> getNonlocalWrites(@NotNull List<Instruction> instructions, @NotNull ScopeOwner owner) {
        if (instructions == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(26);
        }
        if (owner == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(27);
        }
        Scope scope = ControlFlowCache.getScope(owner);
        LinkedHashSet<String> nonlocalWrites = new LinkedHashSet<String>();
        for (Instruction instruction : PyCodeFragmentUtil.getWriteInstructions(instructions)) {
            String name2;
            if (!(instruction instanceof ReadWriteInstruction) || !scope.isNonlocal(name2 = ((ReadWriteInstruction)instruction).getName())) continue;
            nonlocalWrites.add(name2);
        }
        LinkedHashSet<String> linkedHashSet = nonlocalWrites;
        if (linkedHashSet == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(28);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<PsiElement> multiResolve(@NotNull PsiReference reference) {
        if (reference == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(29);
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            ArrayList<PsiElement> resolved = new ArrayList<PsiElement>();
            for (ResolveResult result2 : results) {
                PsiElement element = result2.getElement();
                if (element == null) continue;
                resolved.add(element);
            }
            for (PsiElement element : resolved) {
                if (!(element instanceof PyClass)) continue;
                List<PsiElement> list = Collections.singletonList(element);
                if (list == null) {
                    PyCodeFragmentUtil.$$$reportNull$$$0(30);
                }
                return list;
            }
            ArrayList<PsiElement> arrayList = resolved;
            if (arrayList == null) {
                PyCodeFragmentUtil.$$$reportNull$$$0(31);
            }
            return arrayList;
        }
        PsiElement element = reference.resolve();
        if (element != null) {
            List<PsiElement> list = Collections.singletonList(element);
            if (list == null) {
                PyCodeFragmentUtil.$$$reportNull$$$0(32);
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    private static List<Instruction> getReadInstructions(@NotNull List<Instruction> subGraph) {
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(34);
        }
        ArrayList<Instruction> result2 = new ArrayList<Instruction>();
        for (Instruction instruction : subGraph) {
            ReadWriteInstruction readWriteInstruction;
            if (!(instruction instanceof ReadWriteInstruction) || !(readWriteInstruction = (ReadWriteInstruction)instruction).getAccess().isReadAccess()) continue;
            result2.add((Instruction)readWriteInstruction);
        }
        ArrayList<Instruction> arrayList = result2;
        if (arrayList == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    private static List<Instruction> getWriteInstructions(@NotNull List<Instruction> subGraph) {
        if (subGraph == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(36);
        }
        ArrayList<Instruction> result2 = new ArrayList<Instruction>();
        for (Instruction instruction : subGraph) {
            ReadWriteInstruction readWriteInstruction;
            if (!(instruction instanceof ReadWriteInstruction) || !(readWriteInstruction = (ReadWriteInstruction)instruction).getAccess().isWriteAccess()) continue;
            result2.add((Instruction)readWriteInstruction);
        }
        ArrayList<Instruction> arrayList = result2;
        if (arrayList == null) {
            PyCodeFragmentUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 12, 15, 18, 20, 23, 28, 30, 31, 32, 33, 35, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startInScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endInScope";
                break;
            }
            case 3: 
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 19: 
            case 25: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subGraph";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragmentSubGraph";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutgoingEdges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputElements";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterElementsInScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubGraphElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalWrites";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonlocalWrites";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadInstructions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriteInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFragment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToBoundMethodParameter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentSubGraph";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "analyseSubGraph";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOutgoingEdges";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInputElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOutputElements";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterElementsInScope";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSubGraphElements";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalWrites";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isUsedOutside";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNonlocalWrites";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getReadInstructions";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getWriteInstructions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 12, 15, 18, 20, 23, 28, 30, 31, 32, 33, 35, 37 -> new IllegalStateException(string);
        };
    }

    private static class AnalysisResult {
        private final int starImports;
        private final int regularExits;
        private final int returns;
        private final int outerLoopBreaks;
        private final int yieldExpressions;

        AnalysisResult(int starImports, int returns, int regularExits, int outerLoopBreaks, int yieldExpressions) {
            this.starImports = starImports;
            this.regularExits = regularExits;
            this.returns = returns;
            this.outerLoopBreaks = outerLoopBreaks;
            this.yieldExpressions = yieldExpressions;
        }
    }
}

