/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class RunClassInPlugin
extends AbstractCommand {
    public static final String PREFIX = "%runClassInPlugin";
    protected final String myPluginId;
    protected final String myClazzName;
    protected final String myMethodName;
    protected final List<File> myClasspath;

    private static String nextArg(Iterator<String> args, @NotNull String text) {
        if (text == null) {
            RunClassInPlugin.$$$reportNull$$$0(0);
        }
        if (!args.hasNext()) {
            throw new RuntimeException("Too few arguments in " + text);
        }
        return args.next();
    }

    public RunClassInPlugin(@NotNull String text, int line) {
        if (text == null) {
            RunClassInPlugin.$$$reportNull$$$0(1);
        }
        super(text, line);
        Iterator<String> args = StringUtil.splitHonorQuotes((String)text, (char)' ').stream().map(StringUtil::unquoteString).iterator();
        RunClassInPlugin.nextArg(args, text);
        this.myPluginId = RunClassInPlugin.nextArg(args, text);
        this.myClazzName = RunClassInPlugin.nextArg(args, text);
        this.myMethodName = RunClassInPlugin.nextArg(args, text);
        ArrayList classpath = new ArrayList();
        args.forEachRemaining(arg -> classpath.add(new File((String)arg)));
        this.myClasspath = Collections.unmodifiableList(classpath);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            RunClassInPlugin.$$$reportNull$$$0(2);
        }
        AsyncPromise promise = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            try {
                this.computePromise(context.getProject());
                promise.setResult((Object)"completed");
            }
            catch (Throwable t) {
                promise.setError(t);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            RunClassInPlugin.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    public void computePromise(@NotNull Project project) throws Exception {
        IdeaPluginDescriptor plugin;
        if (project == null) {
            RunClassInPlugin.$$$reportNull$$$0(4);
        }
        if ((plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)this.myPluginId))) == null) {
            throw new RuntimeException("Failed to find plugin: " + this.myPluginId);
        }
        ClassLoader loader = plugin.getClassLoader();
        URLClassLoader classLoader = new URLClassLoader(this.convertClasspathToURLs(), loader);
        this.runWithClassLoader(project, classLoader);
    }

    public URL[] convertClasspathToURLs() {
        return (URL[])this.myClasspath.stream().map(f -> {
            try {
                URL fileURL = f.toURI().toURL();
                if (!fileURL.getProtocol().equals("file")) {
                    throw new RuntimeException("Remote resources are not allowed in the classpath: " + fileURL);
                }
                return fileURL;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to get URL for " + f + ". " + e.getMessage(), e);
            }
        }).toArray(URL[]::new);
    }

    protected void runWithClassLoader(@NotNull Project project, URLClassLoader classLoader) throws ReflectiveOperationException {
        if (project == null) {
            RunClassInPlugin.$$$reportNull$$$0(5);
        }
        ClassLoaderUtil.runWithClassLoader((ClassLoader)classLoader, () -> {
            Class<?> aClass = classLoader.loadClass(this.myClazzName);
            Object newInstance = aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.invokeMethod(project, aClass, newInstance);
        });
    }

    protected void invokeMethod(@NotNull Project project, @NotNull Class<?> aClass, Object instance) throws IllegalAccessException, InvocationTargetException {
        if (project == null) {
            RunClassInPlugin.$$$reportNull$$$0(6);
        }
        if (aClass == null) {
            RunClassInPlugin.$$$reportNull$$$0(7);
        }
        try {
            Method method = aClass.getMethod(this.myMethodName, Project.class);
            method.invoke(instance, project);
            return;
        }
        catch (NoSuchMethodException method) {
        }
        catch (InvocationTargetException e) {
            RunClassInPlugin.rethrowInvocationTargetExceptionCauseIfCan(e);
        }
        try {
            Method method = aClass.getMethod(this.myMethodName, new Class[0]);
            method.invoke(instance, new Object[0]);
            return;
        }
        catch (NoSuchMethodException method) {
        }
        catch (InvocationTargetException e) {
            RunClassInPlugin.rethrowInvocationTargetExceptionCauseIfCan(e);
        }
        throw new RuntimeException("Class " + this.myClazzName + " does not have " + this.myMethodName + " with no or Project parameter");
    }

    private static void rethrowInvocationTargetExceptionCauseIfCan(InvocationTargetException e) throws InvocationTargetException {
        Throwable throwable = e.getCause();
        if (throwable instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)throwable;
            throw re;
        }
        throwable = e.getCause();
        if (throwable instanceof Error) {
            Error err = (Error)throwable;
            throw err;
        }
        throw e;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/RunClassInPlugin";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/RunClassInPlugin";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nextArg";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computePromise";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWithClassLoader";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

