/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.ruby.correctness;

import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.OnRangeElementsEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.features.correctness.SpecialRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

final class RubyDuplicateDeclarationsChecker
extends OnRangeElementsEnrichmentTool {
    RubyDuplicateDeclarationsChecker() {
    }

    @Override
    @NotNull
    public List<SpecialRange> runForElement(@NotNull PsiFile originalFile, final int suggestionOffset, final @NotNull String suggestion, @NotNull PsiElement element) {
        if (originalFile == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(0);
        }
        if (suggestion == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(2);
        }
        if (!(originalFile instanceof RFile)) {
            List<SpecialRange> list = Collections.emptyList();
            if (list == null) {
                RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(3);
            }
            return list;
        }
        final ArrayList<SpecialRange> errors = new ArrayList<SpecialRange>();
        RubyElementVisitor visitor2 = new RubyElementVisitor(){

            public void visitRClass(@NotNull RClass clazz) {
                FQN fqn;
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((fqn = clazz.getFQNWithNesting()) == FQN.INVALID) {
                    return;
                }
                TextRange location = (TextRange)ObjectUtils.doIfNotNull((Object)clazz.getClassName(), it -> RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(it.getTextRange(), suggestionOffset, suggestion));
                if (location == null) {
                    return;
                }
                PsiFile psiFile = clazz.getContainingFile();
                if (!(psiFile instanceof RFile)) {
                    return;
                }
                RFile file = (RFile)psiFile;
                for (RContainer container : RContainerUtil.getStructureElementsRecursively((RContainer)file)) {
                    if (clazz.equals(container) || container instanceof RObjectClass || !(container instanceof RClass) || !fqn.equals(container.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            public void visitRMethod(@NotNull RMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                RContainer container = method.getParentContainer();
                PsiElement identifier = method.getNameIdentifier();
                if (container == null || identifier == null || method.getName() == null) {
                    return;
                }
                TextRange location = RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(identifier.getTextRange(), suggestionOffset, suggestion);
                if (location == null) {
                    return;
                }
                for (PsiElement statement : container.getStatements()) {
                    if (!(statement instanceof RMethod)) continue;
                    RMethod candidate = (RMethod)statement;
                    if (method.equals(statement) || !method.getFQNWithNesting().equals(candidate.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            public void visitRModule(@NotNull RModule module) {
                FQN fqn;
                if (module == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((fqn = module.getFQNWithNesting()) == FQN.INVALID) {
                    return;
                }
                TextRange location = (TextRange)ObjectUtils.doIfNotNull((Object)module.getModuleName(), it -> RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(it.getTextRange(), suggestionOffset, suggestion));
                if (location == null) {
                    return;
                }
                PsiFile psiFile = module.getContainingFile();
                if (!(psiFile instanceof RFile)) {
                    return;
                }
                RFile file = (RFile)psiFile;
                for (RContainer container : RContainerUtil.getStructureElementsRecursively((RContainer)file)) {
                    if (module.equals(container) || !(container instanceof RModule) || !fqn.equals(container.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(3);
                }
                RContainer container = method.getParentContainer();
                PsiElement identifier = method.getNameIdentifier();
                if (container == null || identifier == null || method.getName() == null) {
                    return;
                }
                TextRange location = RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(identifier.getTextRange(), suggestionOffset, suggestion);
                if (location == null) {
                    return;
                }
                for (PsiElement statement : container.getStatements()) {
                    if (!(statement instanceof RSingletonMethod)) continue;
                    RSingletonMethod candidate = (RSingletonMethod)statement;
                    if (method.equals(statement) || !method.getFQNWithNesting().equals(candidate.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ml/inline/completion/ruby/correctness/RubyDuplicateDeclarationsChecker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRModule";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRSingletonMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        element.accept((PsiElementVisitor)visitor2);
        ArrayList<SpecialRange> arrayList = errors;
        if (arrayList == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ml/inline/completion/ruby/correctness/RubyDuplicateDeclarationsChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ml/inline/completion/ruby/correctness/RubyDuplicateDeclarationsChecker";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runForElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runForElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

