/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.AppendPartOfCharArrayKt;
import androidx.compose.ui.text.input.GapBufferKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/text/input/GapBuffer;", "", "initBuffer", "", "initGapStart", "", "initGapEnd", "([CII)V", "buffer", "capacity", "gapEnd", "gapStart", "append", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "delete", "start", "end", "gapLength", "get", "", "index", "length", "makeSureAvailableSpace", "requestSize", "replace", "text", "", "toString", "ui-text"})
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/GapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
final class GapBuffer {
    private int capacity;
    @NotNull
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    public GapBuffer(@NotNull char[] initBuffer, int initGapStart, int initGapEnd) {
        Intrinsics.checkNotNullParameter((Object)initBuffer, (String)"initBuffer");
        this.capacity = initBuffer.length;
        this.buffer = initBuffer;
        this.gapStart = initGapStart;
        this.gapEnd = initGapEnd;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    public final char get(int index2) {
        if (index2 < this.gapStart) {
            return this.buffer[index2];
        }
        return this.buffer[index2 - this.gapStart + this.gapEnd];
    }

    private final void makeSureAvailableSpace(int requestSize) {
        if (requestSize <= this.gapLength()) {
            return;
        }
        int necessarySpace = requestSize - this.gapLength();
        int newCapacity = this.capacity * 2;
        while (newCapacity - this.capacity < necessarySpace) {
            newCapacity *= 2;
        }
        char[] newBuffer = new char[newCapacity];
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)0, (int)0, (int)this.gapStart);
        int tailLength = this.capacity - this.gapEnd;
        int newEnd = newCapacity - tailLength;
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)newEnd, (int)this.gapEnd, (int)(this.gapEnd + tailLength));
        this.buffer = newBuffer;
        this.capacity = newCapacity;
        this.gapEnd = newEnd;
    }

    private final void delete(int start, int end2) {
        if (start < this.gapStart && end2 <= this.gapStart) {
            int copyLen = this.gapStart - end2;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)(this.gapEnd - copyLen), (int)end2, (int)this.gapStart);
            this.gapStart = start;
            this.gapEnd -= copyLen;
        } else if (start < this.gapStart && end2 >= this.gapStart) {
            this.gapEnd = end2 + this.gapLength();
            this.gapStart = start;
        } else {
            int startInBuffer = start + this.gapLength();
            int endInBuffer = end2 + this.gapLength();
            int copyLen = startInBuffer - this.gapEnd;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)this.gapStart, (int)this.gapEnd, (int)startInBuffer);
            this.gapStart += copyLen;
            this.gapEnd = endInBuffer;
        }
    }

    public final void replace(int start, int end2, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.makeSureAvailableSpace(text.length() - (end2 - start));
        this.delete(start, end2);
        GapBufferKt.access$toCharArray(text, this.buffer, this.gapStart);
        this.gapStart += text.length();
    }

    public final void append(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        AppendPartOfCharArrayKt.appendPartOfCharArray(builder, this.buffer, 0, this.gapStart);
        AppendPartOfCharArrayKt.appendPartOfCharArray(builder, this.buffer, this.gapEnd, this.capacity - this.gapEnd);
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append((CharSequence)$this$toString_u24lambda_u240);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

