/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.git.record;

import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncFilteringKt;
import com.intellij.settingsSync.git.record.HistoryRecord;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0003,-.B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0016H\u0002J\b\u0010)\u001a\u00020\u0016H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u0016H\u0002J\n\u0010+\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"Lcom/intellij/settingsSync/git/record/ChangeRecord;", "Lcom/intellij/settingsSync/git/record/HistoryRecord;", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "isFirstCommit", "", "isLastCommit", "commits", "", "<init>", "(ILcom/intellij/vcs/log/VcsFullCommitDetails;ZZLjava/util/List;)V", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "()Ljava/util/List;", "origin", "Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin;", "getOrigin", "()Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin;", "title", "", "getTitle", "()Ljava/lang/String;", "build", "getBuild", "host", "getHost", "restored", "getRestored", "os", "Lcom/intellij/settingsSync/git/record/ChangeRecord$OperatingSystem;", "getOs", "()Lcom/intellij/settingsSync/git/record/ChangeRecord$OperatingSystem;", "getChangeOrigin", "getChangedCategories", "toString", "category", "Lcom/intellij/openapi/components/SettingsCategory;", "parseBuildFromCommitDetails", "parseHostFromCommitDetails", "parseRestoredFromCommitDetails", "parseOSFromCommitDetails", "Companion", "OperatingSystem", "ChangeOrigin", "intellij.settingsSync.git"})
@SourceDebugExtension(value={"SMAP\nChangeRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeRecord.kt\ncom/intellij/settingsSync/git/record/ChangeRecord\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,215:1\n669#2,11:216\n1557#2:227\n1628#2,3:228\n1053#2:231\n1628#2,3:232\n669#2,11:235\n669#2,11:246\n669#2,11:257\n295#2,2:268\n669#2,11:270\n14#3:281\n*S KotlinDebug\n*F\n+ 1 ChangeRecord.kt\ncom/intellij/settingsSync/git/record/ChangeRecord\n*L\n100#1:216,11\n135#1:227\n135#1:228,3\n135#1:231\n135#1:232,3\n154#1:235,11\n163#1:246,11\n172#1:257,11\n176#1:268,2\n189#1:270,11\n88#1:281\n*E\n"})
public final class ChangeRecord
extends HistoryRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsFullCommitDetails commitDetails;
    @NotNull
    private final List<VcsFullCommitDetails> commits;
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final ChangeOrigin origin;
    @NotNull
    private final String title;
    @NotNull
    private final String build;
    @NotNull
    private final String host;
    @Nullable
    private final String restored;
    @Nullable
    private final OperatingSystem os;
    @NotNull
    private static final Logger logger;

    public ChangeRecord(int commitId, @NotNull VcsFullCommitDetails commitDetails, boolean isFirstCommit, boolean isLastCommit, @NotNull List<? extends VcsFullCommitDetails> commits) {
        Intrinsics.checkNotNullParameter((Object)commitDetails, (String)"commitDetails");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        super(commitId, commitDetails, isFirstCommit, isLastCommit, null);
        this.commitDetails = commitDetails;
        this.commits = commits;
        Collection collection = this.commitDetails.getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
        this.changes = CollectionsKt.toList((Iterable)collection);
        this.origin = this.getChangeOrigin();
        this.title = this.getChangedCategories();
        this.build = this.parseBuildFromCommitDetails();
        this.host = this.parseHostFromCommitDetails();
        this.restored = this.parseRestoredFromCommitDetails();
        this.os = this.parseOSFromCommitDetails();
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    @NotNull
    public final ChangeOrigin getOrigin() {
        return this.origin;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getBuild() {
        return this.build;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final String getRestored() {
        return this.restored;
    }

    @Nullable
    public final OperatingSystem getOs() {
        return this.os;
    }

    private final ChangeOrigin getChangeOrigin() {
        Object v1;
        block3: {
            String string = this.commitDetails.getFullMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
            Iterable $this$singleOrNull$iv = StringsKt.lines((CharSequence)string);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"id:", (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    v1 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        String string = v1;
        if (string == null) {
            return ChangeOrigin.Local.INSTANCE;
        }
        String idInCommitMessage = string;
        return StringsKt.contains$default((CharSequence)idInCommitMessage, (CharSequence)"[this]", (boolean)false, (int)2, null) ? (ChangeOrigin)ChangeOrigin.Local.INSTANCE : (StringsKt.contains$default((CharSequence)idInCommitMessage, (CharSequence)"[other]", (boolean)false, (int)2, null) ? (ChangeOrigin)ChangeOrigin.Remote.INSTANCE : (ChangeOrigin)ChangeOrigin.Local.INSTANCE);
    }

    private final String getChangedCategories() {
        SettingsCategory it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (this.isFirstCommit()) {
            return "Initial";
        }
        Iterable $this$map$iv = this.changes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Change change = (Change)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChangeRecord.getChangedCategories$getChangeCategory((Change)it));
        }
        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SettingsCategory it = (SettingsCategory)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(ChangeRecord.access$getChangedCategories$getCategoryOrder(it));
                it = (SettingsCategory)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ChangeRecord.access$getChangedCategories$getCategoryOrder(it)));
            }
        });
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SettingsCategory)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toString(it));
        }
        List changesCategories = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)changesCategories, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String toString(SettingsCategory category) {
        return switch (WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1 -> SettingsSyncBundle.INSTANCE.message("ui.toolwindow.change.category.system", new Object[0]);
            case 2 -> SettingsSyncBundle.INSTANCE.message("ui.toolwindow.change.category.code", new Object[0]);
            case 3 -> SettingsSyncBundle.INSTANCE.message("ui.toolwindow.change.category.plugins", new Object[0]);
            case 4 -> SettingsSyncBundle.INSTANCE.message("ui.toolwindow.change.category.keymap", new Object[0]);
            case 5 -> SettingsSyncBundle.INSTANCE.message("ui.toolwindow.change.category.tools", new Object[0]);
            case 6 -> SettingsSyncBundle.INSTANCE.message("ui.toolwindow.change.category.ui", new Object[0]);
            case 7 -> SettingsSyncBundle.INSTANCE.message("ui.toolwindow.change.category.other", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String parseBuildFromCommitDetails() {
        Object v1;
        block2: {
            String string = this.commitDetails.getFullMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
            Iterable $this$singleOrNull$iv = StringsKt.lines((CharSequence)string);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"build:", (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    v1 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        String string = v1;
        if (string == null) return "";
        String string2 = StringsKt.removePrefix((String)string, (CharSequence)"build:");
        if (string2 == null) return "";
        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (string3 == null) return "";
        String string4 = string3;
        return string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String parseHostFromCommitDetails() {
        Object v1;
        block2: {
            String string = this.commitDetails.getFullMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
            Iterable $this$singleOrNull$iv = StringsKt.lines((CharSequence)string);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"host:", (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    v1 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        String string = v1;
        if (string == null) return "";
        String string2 = StringsKt.removePrefix((String)string, (CharSequence)"host:");
        if (string2 == null) return "";
        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (string3 == null) return "";
        String string4 = string3;
        return string4;
    }

    private final String parseRestoredFromCommitDetails() {
        String string;
        Object v2;
        String hash;
        block10: {
            String $i$f$singleOrNull2;
            block12: {
                block11: {
                    Object v1;
                    Object $this$singleOrNull$iv;
                    block9: {
                        String string2 = this.commitDetails.getFullMessage();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullMessage(...)");
                        $this$singleOrNull$iv = StringsKt.lines((CharSequence)string2);
                        boolean $i$f$singleOrNull2 = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        Iterator iterator = $this$singleOrNull$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            String it = (String)element$iv;
                            boolean bl = false;
                            if (!StringsKt.startsWith$default((String)it, (String)"restores:", (boolean)false, (int)2, null)) continue;
                            if (found$iv) {
                                v1 = null;
                                break block9;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v1 = !found$iv ? null : single$iv;
                    }
                    String string3 = v1;
                    if (string3 == null || ($this$singleOrNull$iv = StringsKt.removePrefix((String)string3, (CharSequence)"restores:")) == null) break block11;
                    $i$f$singleOrNull2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)$this$singleOrNull$iv))).toString();
                    if ($i$f$singleOrNull2 != null) break block12;
                }
                return null;
            }
            hash = $i$f$singleOrNull2;
            Iterable $this$firstOrNull$iv = this.commits;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VcsFullCommitDetails it = (VcsFullCommitDetails)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Hash)it.getId()).asString(), (Object)hash)) continue;
                v2 = element$iv;
                break block10;
            }
            v2 = null;
        }
        VcsFullCommitDetails commitForHash = v2;
        if (commitForHash == null) {
            var3_1 = new Object[]{hash};
            string = SettingsSyncBundle.INSTANCE.message("ui.toolwindow.restored.to.hash.text", var3_1);
        } else {
            var3_1 = new Object[]{this.getTime(commitForHash.getTimestamp())};
            string = SettingsSyncBundle.INSTANCE.message("ui.toolwindow.restored.from.date.text", var3_1);
        }
        return string;
    }

    private final OperatingSystem parseOSFromCommitDetails() {
        String string;
        block7: {
            block6: {
                String string2;
                Object v1;
                block5: {
                    String string3 = this.commitDetails.getFullMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullMessage(...)");
                    Iterable $this$singleOrNull$iv = StringsKt.lines((CharSequence)string3);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"os:", (boolean)false, (int)2, null)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                String string4 = v1;
                if (string4 == null || (string2 = StringsKt.removePrefix((String)string4, (CharSequence)"os:")) == null) break block6;
                String string5 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (string5 == null) break block6;
                String string6 = string5.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                string = string6;
                if (string != null) break block7;
            }
            return null;
        }
        String osString = string;
        return StringsKt.contains$default((CharSequence)osString, (CharSequence)"linux", (boolean)false, (int)2, null) ? OperatingSystem.LINUX : (StringsKt.contains$default((CharSequence)osString, (CharSequence)"macos", (boolean)false, (int)2, null) ? OperatingSystem.MAC : (StringsKt.contains$default((CharSequence)osString, (CharSequence)"windows", (boolean)false, (int)2, null) ? OperatingSystem.WINDOWS : null));
    }

    private static final int getChangedCategories$getCategoryOrder(SettingsCategory category) {
        return switch (WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            case 5 -> 5;
            case 6 -> 6;
            case 7 -> 7;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final SettingsCategory getChangedCategories$getChangeCategory(Change change) {
        Object object = change.getVirtualFile();
        if (object == null || (object = object.getName()) == null) {
            return SettingsCategory.OTHER;
        }
        Object fileName = object;
        if (Intrinsics.areEqual((Object)fileName, (Object)"plugins.json")) {
            return SettingsCategory.PLUGINS;
        }
        SettingsCategory settingsCategory = SettingsSyncFilteringKt.getRoamableCategory((String)fileName);
        if (settingsCategory == null || (settingsCategory = (SettingsCategory)settingsCategory.getFirst()) == null) {
            settingsCategory = SettingsCategory.OTHER;
        }
        return settingsCategory;
    }

    public static final /* synthetic */ int access$getChangedCategories$getCategoryOrder(SettingsCategory category) {
        return ChangeRecord.getChangedCategories$getCategoryOrder(category);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChangeRecord.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ChangeRecord.logger = logger;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin;", "", "<init>", "()V", "Local", "Remote", "Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin$Local;", "Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin$Remote;", "intellij.settingsSync.git"})
    public static abstract class ChangeOrigin {
        private ChangeOrigin() {
        }

        public /* synthetic */ ChangeOrigin(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin$Local;", "Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.settingsSync.git"})
        public static final class Local
        extends ChangeOrigin {
            @NotNull
            public static final Local INSTANCE = new Local();

            private Local() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Local";
            }

            public int hashCode() {
                return -980532315;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Local)) {
                    return false;
                }
                Local cfr_ignored_0 = (Local)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin$Remote;", "Lcom/intellij/settingsSync/git/record/ChangeRecord$ChangeOrigin;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.settingsSync.git"})
        public static final class Remote
        extends ChangeOrigin {
            @NotNull
            public static final Remote INSTANCE = new Remote();

            private Remote() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Remote";
            }

            public int hashCode() {
                return -168879284;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Remote)) {
                    return false;
                }
                Remote cfr_ignored_0 = (Remote)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/git/record/ChangeRecord$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/git/record/ChangeRecord$OperatingSystem;", "", "<init>", "(Ljava/lang/String;I)V", "LINUX", "MAC", "WINDOWS", "intellij.settingsSync.git"})
    public static final class OperatingSystem
    extends Enum<OperatingSystem> {
        public static final /* enum */ OperatingSystem LINUX = new OperatingSystem();
        public static final /* enum */ OperatingSystem MAC = new OperatingSystem();
        public static final /* enum */ OperatingSystem WINDOWS = new OperatingSystem();
        private static final /* synthetic */ OperatingSystem[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OperatingSystem[] values() {
            return (OperatingSystem[])$VALUES.clone();
        }

        public static OperatingSystem valueOf(String value) {
            return Enum.valueOf(OperatingSystem.class, value);
        }

        @NotNull
        public static EnumEntries<OperatingSystem> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operatingSystemArray = new OperatingSystem[]{OperatingSystem.LINUX, OperatingSystem.MAC, OperatingSystem.WINDOWS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SettingsCategory.values().length];
            try {
                nArray[SettingsCategory.SYSTEM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsCategory.CODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsCategory.PLUGINS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsCategory.KEYMAP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsCategory.TOOLS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsCategory.UI.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SettingsCategory.OTHER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

