/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "<init>", "()V", "deserialize", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "transformData", "", "value", "Lcom/fasterxml/jackson/databind/JsonNode;", "createAction", "Lcom/jetbrains/fus/reporting/model/lion3/LogEventAction;", "obj", "intellij.platform.statistics.uploader"})
@SourceDebugExtension(value={"SMAP\nLogEventSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogEventSerializer.kt\ncom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,259:1\n1557#2:260\n1628#2,3:261\n32#3,2:264\n*S KotlinDebug\n*F\n+ 1 LogEventSerializer.kt\ncom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer\n*L\n220#1:260\n220#1:261,3\n223#1:264,2\n*E\n"})
public final class LogEventJsonDeserializer
extends JsonDeserializer<LogEvent> {
    @NotNull
    public LogEvent deserialize(@NotNull JsonParser jsonParser, @NotNull DeserializationContext context) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TreeNode treeNode = jsonParser.getCodec().readTree(jsonParser);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
        JsonNode node = (JsonNode)treeNode;
        String recorderVersion = node.get("recorder_version").asText();
        String session = node.get("session").asText();
        String build = node.get("build").asText();
        String bucket = node.get("bucket").asText();
        long time = node.get("time").asLong();
        JsonNode group = node.get("group");
        String groupId = group.get("id").asText();
        String groupVersion = group.get("version").asText();
        JsonNode actionObj = node.get("event");
        Intrinsics.checkNotNull((Object)actionObj);
        LogEventAction action = this.createAction(actionObj);
        Intrinsics.checkNotNull((Object)session);
        Intrinsics.checkNotNull((Object)build);
        Intrinsics.checkNotNull((Object)bucket);
        Intrinsics.checkNotNull((Object)groupId);
        Intrinsics.checkNotNull((Object)groupVersion);
        LogEventGroup logEventGroup = new LogEventGroup(groupId, groupVersion);
        Intrinsics.checkNotNull((Object)recorderVersion);
        return new LogEvent(session, build, bucket, time, logEventGroup, recorderVersion, action);
    }

    /*
     * WARNING - void declaration
     */
    private final Object transformData(JsonNode value) {
        Object object;
        JsonNode jsonNode = value;
        if (jsonNode instanceof TextNode) {
            object = ((TextNode)value).textValue();
        } else if (jsonNode instanceof LongNode) {
            object = ((LongNode)value).longValue();
        } else if (jsonNode instanceof BooleanNode) {
            object = ((BooleanNode)value).booleanValue();
        } else if (jsonNode instanceof ArrayNode) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                collection.add(v1 != null ? this.transformData((JsonNode)v1) : null);
            }
            object = (List)destination$iv$iv;
        } else {
            if (jsonNode instanceof ObjectNode) {
                HashMap data = new HashMap();
                Iterator iterator = ((ObjectNode)value).fields();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
                Iterator $this$forEach$iv = iterator;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                while (iterator2.hasNext()) {
                    JsonNode entryValue;
                    Object element$iv = iterator2.next();
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    String entryKey = (String)entry.getKey();
                    JsonNode jsonNode3 = entryValue = (JsonNode)entry.getValue();
                    Object newValue = jsonNode3 != null ? this.transformData(jsonNode3) : null;
                    ((Map)data).put(entryKey, newValue);
                }
                return data;
            }
            if (jsonNode instanceof DoubleNode) {
                if (((DoubleNode)value).doubleValue() % 1.0 == 0.0) {
                    return MathKt.roundToLong((double)((DoubleNode)value).doubleValue());
                }
                return ((DoubleNode)value).doubleValue();
            }
            object = value;
        }
        String string = object;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final LogEventAction createAction(@NotNull JsonNode obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String id = obj.get("id").asText();
        boolean isState = obj.has("state") && obj.get("state").asBoolean();
        HashMap data = new HashMap();
        if (obj.has("data")) {
            JsonNode dataObj = obj.get("data");
            Iterator fields = dataObj.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                Map map = data;
                Object k = field.getKey();
                Object v = field.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                Object object = this.transformData((JsonNode)v);
                map.put(k, object);
            }
        }
        if (obj.has("count") && obj.get("count").isNumber()) {
            Intrinsics.checkNotNull((Object)id);
            String string = id;
            int n = obj.get("count").asInt();
            return new LogEventAction(string, isState, (Map)data, n);
        }
        Intrinsics.checkNotNull((Object)id);
        return new LogEventAction(id, isState, (Map)data, 0, 8, null);
    }
}

