/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) * ivec3(-36, 32, -88)) => ivec3(1296, 1024, 7744)
 * (ivec3(-36, 32, -88) * ivec3(36, 32, 88)) => ivec3(-1296, 1024, -7744)
 * (ivec3(-36, 32, -88) * ivec3(59, 77, 68)) => ivec3(-2124, 2464, -5984)
 * (ivec3(36, 32, 88) * ivec3(-36, 32, -88)) => ivec3(-1296, 1024, -7744)
 * (ivec3(36, 32, 88) * ivec3(36, 32, 88)) => ivec3(1296, 1024, 7744)
 * (ivec3(36, 32, 88) * ivec3(59, 77, 68)) => ivec3(2124, 2464, 5984)
 * (ivec3(59, 77, 68) * ivec3(-36, 32, -88)) => ivec3(-2124, 2464, -5984)
 * (ivec3(59, 77, 68) * ivec3(36, 32, 88)) => ivec3(2124, 2464, 5984)
 * (ivec3(59, 77, 68) * ivec3(59, 77, 68)) => ivec3(3481, 5929, 4624)
 */
#version 150

void main()
{
  float[all(equal((ivec3(-36, 32, -88) * ivec3(-36, 32, -88)), ivec3(1296, 1024, 7744))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) * ivec3(36, 32, 88)), ivec3(-1296, 1024, -7744))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) * ivec3(59, 77, 68)), ivec3(-2124, 2464, -5984))) ? 1 : -1] array2;
  float[all(equal((ivec3(36, 32, 88) * ivec3(-36, 32, -88)), ivec3(-1296, 1024, -7744))) ? 1 : -1] array3;
  float[all(equal((ivec3(36, 32, 88) * ivec3(36, 32, 88)), ivec3(1296, 1024, 7744))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) * ivec3(59, 77, 68)), ivec3(2124, 2464, 5984))) ? 1 : -1] array5;
  float[all(equal((ivec3(59, 77, 68) * ivec3(-36, 32, -88)), ivec3(-2124, 2464, -5984))) ? 1 : -1] array6;
  float[all(equal((ivec3(59, 77, 68) * ivec3(36, 32, 88)), ivec3(2124, 2464, 5984))) ? 1 : -1] array7;
  float[all(equal((ivec3(59, 77, 68) * ivec3(59, 77, 68)), ivec3(3481, 5929, 4624))) ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
